/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.android.telemetry.NavigationRerouteData;
import java.lang.reflect.Type;
import java.util.Map;

class RerouteDataSerializer
implements JsonSerializer<NavigationRerouteData> {
    private static final String SECOND_SINCE_LAST_REROUTE = "secondsSinceLastReroute";

    RerouteDataSerializer() {
    }

    public JsonElement serialize(NavigationRerouteData src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject rerouteData = new JsonObject();
        rerouteData.addProperty(SECOND_SINCE_LAST_REROUTE, (Number)src.getSecondsSinceLastReroute());
        this.serializeNewData(src, context, rerouteData);
        return rerouteData;
    }

    private void serializeNewData(NavigationRerouteData src, JsonSerializationContext context, JsonObject rerouteData) {
        JsonObject newData = context.serialize((Object)src.getNavigationNewData()).getAsJsonObject();
        for (Map.Entry e : newData.entrySet()) {
            rerouteData.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }
}

