/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineListener;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.LocationReceiver;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.TelemetryCallback;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryReceiver;
import java.util.concurrent.CopyOnWriteArraySet;

public class TelemetryService
extends Service
implements TelemetryCallback,
LocationEngineListener,
EventCallback {
    public static final String IS_LOCATION_ENABLER_FROM_PREFERENCES = "isLocationEnablerFromPreferences";
    private LocationReceiver locationReceiver = null;
    private TelemetryReceiver telemetryReceiver = null;
    private EventsQueue queue = null;
    private int boundInstances = 0;
    private LocationEngine locationEngine = null;
    private LocationEnginePriority locationPriority = LocationEnginePriority.NO_POWER;
    private CopyOnWriteArraySet<ServiceTaskCallback> serviceTaskCallbacks = null;
    private TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationEnablerFromPreferences = true;
    private boolean isLocationReceiverRegistered = false;
    private boolean isTelemetryReceiverRegistered = false;

    public void onCreate() {
        super.onCreate();
        this.createLocationReceiver();
        this.createTelemetryReceiver();
        this.createServiceTaskCallbacks();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.checkApplicationContext();
        this.enableTelemetryLocationState(intent);
        return 3;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new TelemetryBinder();
    }

    public void onDestroy() {
        this.unregisterLocationReceiver();
        this.unregisterTelemetryReceiver();
        this.disableTelemetryLocationState();
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        for (ServiceTaskCallback callback : this.serviceTaskCallbacks) {
            callback.onTaskRemoved();
        }
        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onBackground() {
        System.out.println("TelemetryService#onBackground: Shutting down location receiver...");
        this.unregisterLocationReceiver();
    }

    @Override
    public void onForeground() {
        System.out.println("TelemetryService#onForeground: Restarting location receiver...");
        this.registerLocationReceiver();
    }

    public void onConnected() {
        this.locationEngine.requestLocationUpdates();
    }

    public void onLocationChanged(Location location) {
        this.checkApplicationContext();
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(LocationReceiver.supplyIntent(location));
    }

    @Override
    public void onEventReceived(Event event) {
        if (this.queue != null) {
            this.queue.push(event);
        }
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.locationReceiver.updateSessionIdentifier(sessionIdentifier);
    }

    public void updateLocationPriority(LocationEnginePriority priority) {
        this.locationPriority = priority;
        if (this.locationEngine != null) {
            this.disconnectLocationEngine();
            this.setupLocationEngine();
            this.activateLocationEngine();
        }
    }

    void bindInstance() {
        ++this.boundInstances;
    }

    void unbindInstance() {
        --this.boundInstances;
    }

    int obtainBoundInstances() {
        return this.boundInstances;
    }

    boolean addServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.add(callback);
    }

    boolean removeServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.remove(callback);
    }

    void injectEventsQueue(EventsQueue queue) {
        this.queue = queue;
    }

    boolean isLocationReceiverRegistered() {
        return this.isLocationReceiverRegistered;
    }

    boolean isTelemetryReceiverRegistered() {
        return this.isTelemetryReceiverRegistered;
    }

    private void createLocationReceiver() {
        this.locationReceiver = new LocationReceiver(this);
        this.registerLocationReceiver();
    }

    private void registerLocationReceiver() {
        this.connectLocationEngine();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.locationReceiver, new IntentFilter("com.mapbox.location_receiver"));
        this.isLocationReceiverRegistered = true;
    }

    private void connectLocationEngine() {
        this.obtainLocationEngine();
        this.setupLocationEngine();
        this.activateLocationEngine();
    }

    private void obtainLocationEngine() {
        this.locationEngine = new LocationEngineProvider((Context)this).obtainBestLocationEngineAvailable();
    }

    private void setupLocationEngine() {
        this.locationEngine.setPriority(this.locationPriority);
        this.locationEngine.addLocationEngineListener((LocationEngineListener)this);
    }

    private void activateLocationEngine() {
        this.locationEngine.activate();
    }

    private void createTelemetryReceiver() {
        this.telemetryReceiver = new TelemetryReceiver(this);
        this.registerTelemetryReceiver();
    }

    private void registerTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.telemetryReceiver, new IntentFilter("com.mapbox.telemetry_receiver"));
        this.isTelemetryReceiverRegistered = true;
    }

    private void createServiceTaskCallbacks() {
        this.serviceTaskCallbacks = new CopyOnWriteArraySet();
    }

    private void enableTelemetryLocationState(Intent intent) {
        this.isLocationEnablerFromPreferences = intent.getBooleanExtra(IS_LOCATION_ENABLER_FROM_PREFERENCES, true);
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.ENABLED);
        }
    }

    private void unregisterLocationReceiver() {
        this.disconnectLocationEngine();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
        this.isLocationReceiverRegistered = false;
    }

    private void disconnectLocationEngine() {
        this.removeLocationUpdates();
        this.deactivateLocationEngine();
    }

    private void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates();
        this.locationEngine.removeLocationEngineListener((LocationEngineListener)this);
    }

    private void deactivateLocationEngine() {
        this.locationEngine.deactivate();
    }

    private void unregisterTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.telemetryReceiver);
        this.isTelemetryReceiverRegistered = false;
    }

    private void disableTelemetryLocationState() {
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED);
        }
    }

    private void checkApplicationContext() {
        if (MapboxTelemetry.applicationContext == null) {
            MapboxTelemetry.applicationContext = this.getApplicationContext();
        }
    }

    private void createLocationEnabler() {
        if (this.telemetryLocationEnabler == null) {
            this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
        }
    }

    class TelemetryBinder
    extends Binder {
        TelemetryBinder() {
        }

        TelemetryService obtainService() {
            return TelemetryService.this;
        }
    }
}

