/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.EnvironmentResolver;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientBuild;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import java.util.HashMap;
import java.util.Map;

class TelemetryClientFactory {
    private static final String LOG_TAG = "TelemetryClientFactory";
    private static final String RETRIEVING_APP_META_DATA_ERROR_MESSAGE = "Failed when retrieving app meta-data: %s";
    private final String accessToken;
    private final String userAgent;
    private final Logger logger;
    private final Map<Environment, TelemetryClientBuild> BUILD_TELEMETRY_CLIENT = new HashMap<Environment, TelemetryClientBuild>(){
        {
            this.put(Environment.CHINA, new TelemetryClientBuild(){

                @Override
                public TelemetryClient build(ServerInformation serverInformation) {
                    return TelemetryClientFactory.this.buildTelemetryClient(Environment.CHINA);
                }
            });
            this.put(Environment.STAGING, new TelemetryClientBuild(){

                @Override
                public TelemetryClient build(ServerInformation serverInformation) {
                    return TelemetryClientFactory.this.buildTelemetryClientCustom(serverInformation);
                }
            });
            this.put(Environment.COM, new TelemetryClientBuild(){

                @Override
                public TelemetryClient build(ServerInformation serverInformation) {
                    return TelemetryClientFactory.this.buildTelemetryClient(Environment.COM);
                }
            });
        }
    };

    TelemetryClientFactory(String accessToken, String userAgent, Logger logger) {
        this.accessToken = accessToken;
        this.userAgent = userAgent;
        this.logger = logger;
    }

    TelemetryClient obtainTelemetryClient(Context context) {
        EnvironmentChain environmentChain = new EnvironmentChain();
        EnvironmentResolver setupChain = environmentChain.setup();
        try {
            ApplicationInfo appInformation = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInformation != null && appInformation.metaData != null) {
                ServerInformation serverInformation = setupChain.obtainServerInformation(appInformation.metaData);
                return this.BUILD_TELEMETRY_CLIENT.get((Object)serverInformation.getEnvironment()).build(serverInformation);
            }
        }
        catch (Exception exception) {
            this.logger.error(LOG_TAG, String.format(RETRIEVING_APP_META_DATA_ERROR_MESSAGE, exception.getMessage()));
        }
        return this.buildTelemetryClient(Environment.COM);
    }

    private TelemetryClient buildTelemetryClient(Environment environment) {
        TelemetryClientSettings telemetryClientSettings = new TelemetryClientSettings.Builder().environment(environment).build();
        TelemetryClient telemetryClient = new TelemetryClient(this.accessToken, this.userAgent, telemetryClientSettings, this.logger);
        return telemetryClient;
    }

    private TelemetryClient buildTelemetryClientCustom(ServerInformation serverInformation) {
        Environment environment = serverInformation.getEnvironment();
        String hostname = serverInformation.getHostname();
        String accessToken = serverInformation.getAccessToken();
        TelemetryClientSettings telemetryClientSettings = new TelemetryClientSettings.Builder().environment(environment).baseUrl(TelemetryClientSettings.configureUrlHostname(hostname)).build();
        TelemetryClient telemetryClient = new TelemetryClient(accessToken, this.userAgent, telemetryClientSettings, this.logger);
        return telemetryClient;
    }
}

