/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.android.telemetry.ArriveEventSerializer;
import com.mapbox.android.telemetry.CancelEventSerializer;
import com.mapbox.android.telemetry.DepartEventSerializer;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FasterRouteEventSerializer;
import com.mapbox.android.telemetry.FeedbackEventSerializer;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.NavigationArriveEvent;
import com.mapbox.android.telemetry.NavigationCancelEvent;
import com.mapbox.android.telemetry.NavigationDepartEvent;
import com.mapbox.android.telemetry.NavigationFasterRouteEvent;
import com.mapbox.android.telemetry.NavigationFeedbackEvent;
import com.mapbox.android.telemetry.NavigationRerouteEvent;
import com.mapbox.android.telemetry.RerouteEventSerializer;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

class TelemetryClient {
    private static final String LOG_TAG = "TelemetryClient";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String EVENTS_ENDPOINT = "/events/v2";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String EXTRA_DEBUGGING_LOG = "Sending POST to %s with %d event(s) (user agent: %s) with payload: %s";
    private String accessToken = null;
    private String userAgent = null;
    private TelemetryClientSettings setting;
    private final Logger logger;

    TelemetryClient(String accessToken, String userAgent, TelemetryClientSettings setting, Logger logger) {
        this.accessToken = accessToken;
        this.userAgent = userAgent;
        this.setting = setting;
        this.logger = logger;
    }

    void updateAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    void updateUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    void sendEvents(List<Event> events, Callback callback) {
        ArrayList<Event> batch = new ArrayList<Event>();
        batch.addAll(events);
        this.sendBatch(batch, callback);
    }

    void updateDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.setting = this.setting.toBuilder().debugLoggingEnabled(debugLoggingEnabled).build();
    }

    String obtainAccessToken() {
        return this.accessToken;
    }

    TelemetryClientSettings obtainSetting() {
        return this.setting;
    }

    private void sendBatch(List<Event> batch, Callback callback) {
        GsonBuilder gsonBuilder = this.configureGsonBuilder();
        Gson gson = gsonBuilder.create();
        String payload = gson.toJson(batch);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        HttpUrl baseUrl = this.setting.getBaseUrl();
        HttpUrl url = baseUrl.newBuilder(EVENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        if (this.isExtraDebuggingNeeded()) {
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, url, batch.size(), this.userAgent, payload));
        }
        Request request = new Request.Builder().url(url).header(USER_AGENT_REQUEST_HEADER, this.userAgent).post(body).build();
        OkHttpClient client = this.setting.getClient();
        client.newCall(request).enqueue(callback);
    }

    private boolean isExtraDebuggingNeeded() {
        return this.setting.isDebugLoggingEnabled() || this.setting.getEnvironment().equals((Object)Environment.STAGING);
    }

    private GsonBuilder configureGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        ArriveEventSerializer arriveSerializer = new ArriveEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationArriveEvent.class, (Object)arriveSerializer);
        DepartEventSerializer departSerializer = new DepartEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationDepartEvent.class, (Object)departSerializer);
        CancelEventSerializer cancelSerializer = new CancelEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationCancelEvent.class, (Object)cancelSerializer);
        FeedbackEventSerializer feedbackSerializer = new FeedbackEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationFeedbackEvent.class, (Object)feedbackSerializer);
        RerouteEventSerializer rerouteSerializer = new RerouteEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationRerouteEvent.class, (Object)rerouteSerializer);
        FasterRouteEventSerializer fasterRouteSerializer = new FasterRouteEventSerializer();
        gsonBuilder.registerTypeAdapter(NavigationFasterRouteEvent.class, (Object)fasterRouteSerializer);
        return gsonBuilder;
    }
}

