/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapBuildEvent;
import com.mapbox.android.telemetry.MapClickEvent;
import com.mapbox.android.telemetry.MapDragendEvent;
import com.mapbox.android.telemetry.MapLoadEvent;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

public class MapEventFactory {
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private static final String SINGLE_CARRIER_RTT = "1xRTT";
    private static final String CODE_DIVISION_MULTIPLE_ACCESS = "CDMA";
    private static final String ENHANCED_DATA_GSM_EVOLUTION = "EDGE";
    private static final String ENHANCED_HIGH_RATE_PACKET_DATA = "EHRPD";
    private static final String EVOLUTION_DATA_OPTIMIZED_0 = "EVDO_0";
    private static final String EVOLUTION_DATA_OPTIMIZED_A = "EVDO_A";
    private static final String EVOLUTION_DATA_OPTIMIZED_B = "EVDO_B";
    private static final String GENERAL_PACKET_RADIO_SERVICE = "GPRS";
    private static final String HIGH_SPEED_DOWNLINK_PACKET_ACCESS = "HSDPA";
    private static final String HIGH_SPEED_PACKET_ACCESS = "HSPA";
    private static final String HIGH_SPEED_PACKET_ACCESS_PLUS = "HSPAP";
    private static final String HIGH_SPEED_UNLINK_PACKET_ACCESS = "HSUPA";
    private static final String INTEGRATED_DIGITAL_ENHANCED_NETWORK = "IDEN";
    private static final String LONG_TERM_EVOLUTION = "LTE";
    private static final String UNIVERSAL_MOBILE_TELCO_SERVICE = "UMTS";
    private static final String UNKNOWN = "Unknown";
    private static final String LANDSCAPE = "Landscape";
    private static final String PORTRAIT = "Portrait";
    private static final String NO_CARRIER = "EMPTY_CARRIER";
    private static final int UNAVAILABLE_BATTERY_LEVEL = -1;
    private static final int DEFAULT_BATTERY_LEVEL = -1;
    private static final int NO_NETWORK = -1;
    private static final String NOT_A_LOAD_MAP_EVENT_TYPE = "Type must be a load map event.";
    private static final String NOT_A_GESTURE_MAP_EVENT_TYPE = "Type must be a gesture map event.";
    private static final String MAP_STATE_ILLEGAL_NULL = "MapState cannot be null.";
    private static final Map<Integer, String> NETWORKS = new HashMap<Integer, String>(){
        {
            this.put(7, MapEventFactory.SINGLE_CARRIER_RTT);
            this.put(4, MapEventFactory.CODE_DIVISION_MULTIPLE_ACCESS);
            this.put(2, MapEventFactory.ENHANCED_DATA_GSM_EVOLUTION);
            this.put(14, MapEventFactory.ENHANCED_HIGH_RATE_PACKET_DATA);
            this.put(5, MapEventFactory.EVOLUTION_DATA_OPTIMIZED_0);
            this.put(6, MapEventFactory.EVOLUTION_DATA_OPTIMIZED_A);
            this.put(12, MapEventFactory.EVOLUTION_DATA_OPTIMIZED_B);
            this.put(1, MapEventFactory.GENERAL_PACKET_RADIO_SERVICE);
            this.put(8, MapEventFactory.HIGH_SPEED_DOWNLINK_PACKET_ACCESS);
            this.put(10, MapEventFactory.HIGH_SPEED_PACKET_ACCESS);
            this.put(15, MapEventFactory.HIGH_SPEED_PACKET_ACCESS_PLUS);
            this.put(9, MapEventFactory.HIGH_SPEED_UNLINK_PACKET_ACCESS);
            this.put(11, MapEventFactory.INTEGRATED_DIGITAL_ENHANCED_NETWORK);
            this.put(13, MapEventFactory.LONG_TERM_EVOLUTION);
            this.put(3, MapEventFactory.UNIVERSAL_MOBILE_TELCO_SERVICE);
            this.put(0, MapEventFactory.UNKNOWN);
        }
    };
    private static final Map<Integer, String> ORIENTATIONS = new HashMap<Integer, String>(){
        {
            this.put(2, MapEventFactory.LANDSCAPE);
            this.put(1, MapEventFactory.PORTRAIT);
        }
    };
    private final Map<Event.Type, MapBuildEvent> BUILD_EVENT_MAP_GESTURE = new HashMap<Event.Type, MapBuildEvent>(){
        {
            this.put(Event.Type.MAP_CLICK, new MapBuildEvent(){

                @Override
                public Event build(MapState mapState) {
                    return MapEventFactory.this.buildMapClickEvent(mapState);
                }
            });
            this.put(Event.Type.MAP_DRAGEND, new MapBuildEvent(){

                @Override
                public Event build(MapState mapState) {
                    return MapEventFactory.this.buildMapDragendEvent(mapState);
                }
            });
        }
    };

    public MapEventFactory() {
        if (MapboxTelemetry.applicationContext == null) {
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
    }

    public Event createMapLoadEvent(Event.Type type) {
        this.checkLoad(type);
        return this.buildMapLoadEvent();
    }

    public Event createMapGestureEvent(Event.Type type, MapState mapState) {
        this.checkGesture(type, mapState);
        return this.BUILD_EVENT_MAP_GESTURE.get((Object)type).build(mapState);
    }

    private MapClickEvent buildMapClickEvent(MapState mapState) {
        MapClickEvent mapClickEvent = new MapClickEvent(mapState);
        mapClickEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapClickEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapClickEvent.setCellularNetworkType(this.obtainCellularNetworkType(MapboxTelemetry.applicationContext));
        mapClickEvent.setBatteryLevel(this.obtainBatteryLevel());
        mapClickEvent.setPluggedIn(this.isPluggedIn());
        mapClickEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapClickEvent;
    }

    private MapDragendEvent buildMapDragendEvent(MapState mapState) {
        MapDragendEvent mapDragendEvent = new MapDragendEvent(mapState);
        mapDragendEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapDragendEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapDragendEvent.setCellularNetworkType(this.obtainCellularNetworkType(MapboxTelemetry.applicationContext));
        mapDragendEvent.setBatteryLevel(this.obtainBatteryLevel());
        mapDragendEvent.setPluggedIn(this.isPluggedIn());
        mapDragendEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapDragendEvent;
    }

    private String obtainOrientation(Context context) {
        return ORIENTATIONS.get(context.getResources().getConfiguration().orientation);
    }

    private float obtainAccessibilityFontScaleSize(Context context) {
        return context.getResources().getConfiguration().fontScale;
    }

    private String obtainCellularCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            return NO_CARRIER;
        }
        return carrierName;
    }

    private String obtainCellularNetworkType(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return NETWORKS.get(manager.getNetworkType());
    }

    private float obtainDisplayDensity(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    private int obtainBatteryLevel() {
        Intent batteryStatus = this.registerBatteryUpdates(MapboxTelemetry.applicationContext);
        if (batteryStatus == null) {
            return -1;
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return Math.round((float)level / (float)scale * 100.0f);
    }

    private Intent registerBatteryUpdates(Context context) {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return context.registerReceiver(null, filter);
    }

    private boolean isPluggedIn() {
        Intent batteryStatus = this.registerBatteryUpdates(MapboxTelemetry.applicationContext);
        int chargePlug = batteryStatus.getIntExtra("plugged", -1);
        boolean pluggedIntoUSB = chargePlug == 2;
        boolean pluggedIntoAC = chargePlug == 1;
        return pluggedIntoUSB || pluggedIntoAC;
    }

    private Boolean obtainConnectedToWifi(Context context) {
        return this.isConnectedToWifi(context);
    }

    private boolean isConnectedToWifi(Context context) {
        try {
            WifiManager wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            return this.isWifiConnected(wifiMgr, wifiInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isWifiConnected(WifiManager wifiMgr, WifiInfo wifiInfo) {
        return wifiMgr.isWifiEnabled() && this.networkConnected(wifiInfo);
    }

    private boolean networkConnected(WifiInfo wifiInfo) {
        return wifiInfo.getNetworkId() != -1;
    }

    private MapLoadEvent buildMapLoadEvent() {
        String userId = TelemetryUtils.retrieveVendorId();
        MapLoadEvent mapLoadEvent = new MapLoadEvent(userId);
        mapLoadEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapLoadEvent.setAccessibilityFontScale(this.obtainAccessibilityFontScaleSize(MapboxTelemetry.applicationContext));
        mapLoadEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapLoadEvent.setCellularNetworkType(this.obtainCellularNetworkType(MapboxTelemetry.applicationContext));
        mapLoadEvent.setResolution(this.obtainDisplayDensity(MapboxTelemetry.applicationContext));
        mapLoadEvent.setBatteryLevel(this.obtainBatteryLevel());
        mapLoadEvent.setPluggedIn(this.isPluggedIn());
        mapLoadEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapLoadEvent;
    }

    private void checkLoad(Event.Type type) {
        if (type != Event.Type.MAP_LOAD) {
            throw new IllegalArgumentException(NOT_A_LOAD_MAP_EVENT_TYPE);
        }
    }

    private void checkGesture(Event.Type type, MapState mapState) {
        this.checkGestureMapEvent(type);
        this.isNotNull(mapState);
    }

    private void checkGestureMapEvent(Event.Type type) {
        if (!Event.mapGestureEventTypes.contains((Object)type)) {
            throw new IllegalArgumentException(NOT_A_GESTURE_MAP_EVENT_TYPE);
        }
    }

    private void isNotNull(MapState mapState) {
        if (mapState == null) {
            throw new IllegalArgumentException(MAP_STATE_ILLEGAL_NULL);
        }
    }
}

