/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.content.Context;
import android.location.Location;
import android.support.annotation.Nullable;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;
import java.lang.ref.WeakReference;

public class LostLocationEngine
extends LocationEngine
implements LocationListener {
    private static LocationEngine instance;
    private WeakReference<Context> context;
    private LostApiClient lostApiClient;

    public LostLocationEngine(Context context) {
        this.context = new WeakReference<Context>(context);
        this.lostApiClient = new LostApiClient.Builder((Context)this.context.get()).build();
    }

    public static synchronized LocationEngine getLocationEngine(Context context) {
        if (instance == null) {
            instance = new LostLocationEngine(context.getApplicationContext());
        }
        return instance;
    }

    @Override
    public void activate() {
        if (!this.lostApiClient.isConnected()) {
            this.lostApiClient.connect();
        }
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onConnected();
        }
    }

    @Override
    public void deactivate() {
        if (this.lostApiClient.isConnected()) {
            this.lostApiClient.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.lostApiClient.isConnected();
    }

    @Override
    @Nullable
    public Location getLastLocation() {
        if (this.lostApiClient.isConnected()) {
            return LocationServices.FusedLocationApi.getLastLocation();
        }
        return null;
    }

    @Override
    public void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create();
        if (this.interval != null) {
            request.setInterval((long)this.interval.intValue());
        }
        if (this.fastestInterval != null) {
            request.setFastestInterval((long)this.fastestInterval.intValue());
        }
        if (this.smallestDisplacement != null) {
            request.setSmallestDisplacement(this.smallestDisplacement.floatValue());
        }
        if (this.priority == 0) {
            request.setPriority(105);
        } else if (this.priority == 1) {
            request.setPriority(104);
        } else if (this.priority == 2) {
            request.setPriority(102);
        } else if (this.priority == 3) {
            request.setPriority(100);
        }
        if (this.lostApiClient.isConnected()) {
            LocationServices.FusedLocationApi.requestLocationUpdates(request, (LocationListener)this);
        }
    }

    @Override
    public LocationEngine.Type obtainType() {
        return LocationEngine.Type.LOST;
    }

    @Override
    public void removeLocationUpdates() {
        if (this.lostApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates((LocationListener)this);
        }
    }

    public void onLocationChanged(Location location) {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }
}

