/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.mapbox.android.core.permissions.PermissionsListener;
import java.util.ArrayList;

public class PermissionsManager {
    private static final String COARSE_LOCATION_PERMISSION = "android.permission.ACCESS_COARSE_LOCATION";
    private static final String FINE_LOCATION_PERMISSION = "android.permission.ACCESS_FINE_LOCATION";
    private final int REQUEST_PERMISSIONS_CODE = 0;
    private PermissionsListener listener;

    public PermissionsManager(PermissionsListener listener) {
        this.listener = listener;
    }

    public PermissionsListener getListener() {
        return this.listener;
    }

    public void setListener(PermissionsListener listener) {
        this.listener = listener;
    }

    private static boolean isPermissionGranted(Context context, String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    private static boolean isCoarseLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, COARSE_LOCATION_PERMISSION);
    }

    private static boolean isFineLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, FINE_LOCATION_PERMISSION);
    }

    public static boolean areLocationPermissionsGranted(Context context) {
        return PermissionsManager.isCoarseLocationPermissionGranted(context) || PermissionsManager.isFineLocationPermissionGranted(context);
    }

    public static boolean areRuntimePermissionsRequired() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public void requestLocationPermissions(Activity activity) {
        this.requestLocationPermissions(activity, true);
    }

    private void requestLocationPermissions(Activity activity, boolean requestFineLocation) {
        String[] stringArray;
        if (requestFineLocation) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = FINE_LOCATION_PERMISSION;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = COARSE_LOCATION_PERMISSION;
        }
        String[] permissions = stringArray;
        this.requestPermissions(activity, permissions);
    }

    private void requestPermissions(Activity activity, String[] permissions) {
        ArrayList<String> permissionsToExplain = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) continue;
            permissionsToExplain.add(permission2);
        }
        if (this.listener != null && permissionsToExplain.size() > 0) {
            this.listener.onExplanationNeeded(permissionsToExplain);
        }
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)0);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 0: {
                if (this.listener == null) break;
                boolean granted = grantResults.length > 0 && grantResults[0] == 0;
                this.listener.onPermissionResult(granted);
                break;
            }
        }
    }
}

