/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.content.Intent;
import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.location.LocationResult;
import com.mapbox.android.core.location.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocationEngineResult {
    private static final String GOOGLE_PLAY_LOCATION_RESULT = "com.google.android.gms.location.LocationResult";
    private final List<Location> locations;

    private LocationEngineResult(List<Location> locations) {
        this.locations = Collections.unmodifiableList(locations);
    }

    @NonNull
    public static LocationEngineResult create(@Nullable Location location) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (location != null) {
            locations.add(location);
        }
        return new LocationEngineResult(locations);
    }

    @NonNull
    public static LocationEngineResult create(@Nullable List<Location> locations) {
        if (locations != null) {
            ArrayList<Location> locationsList = new ArrayList<Location>(locations);
            locationsList.removeAll(Collections.singleton(null));
            return new LocationEngineResult(locationsList);
        }
        return new LocationEngineResult(Collections.emptyList());
    }

    @Nullable
    public Location getLastLocation() {
        return this.locations.isEmpty() ? null : this.locations.get(0);
    }

    public List<Location> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    @Nullable
    public static LocationEngineResult extractResult(Intent intent) {
        LocationEngineResult result = null;
        if (Utils.isOnClasspath(GOOGLE_PLAY_LOCATION_RESULT)) {
            result = LocationEngineResult.extractGooglePlayResult(intent);
        }
        return result == null ? LocationEngineResult.extractAndroidResult(intent) : result;
    }

    private static LocationEngineResult extractGooglePlayResult(Intent intent) {
        LocationResult result = LocationResult.extractResult((Intent)intent);
        return result != null ? LocationEngineResult.create(result.getLocations()) : null;
    }

    private static LocationEngineResult extractAndroidResult(Intent intent) {
        return !LocationEngineResult.hasResult(intent) ? null : LocationEngineResult.create((Location)intent.getExtras().getParcelable("location"));
    }

    private static boolean hasResult(Intent intent) {
        return intent != null && intent.hasExtra("location");
    }
}

