/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.content.Context;
import android.location.LocationListener;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.LocationCallback;
import com.mapbox.android.core.location.GoogleLocationEngineImpl;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineProxy;
import com.mapbox.android.core.location.MapboxFusedLocationEngineImpl;
import com.mapbox.android.core.location.Utils;

public final class LocationEngineProvider {
    private static final String GOOGLE_LOCATION_SERVICES = "com.google.android.gms.location.LocationServices";
    private static final String GOOGLE_API_AVAILABILITY = "com.google.android.gms.common.GoogleApiAvailability";

    private LocationEngineProvider() {
    }

    @Deprecated
    @NonNull
    public static LocationEngine getBestLocationEngine(@NonNull Context context, boolean background) {
        return LocationEngineProvider.getBestLocationEngine(context);
    }

    @NonNull
    public static LocationEngine getBestLocationEngine(@NonNull Context context) {
        Utils.checkNotNull(context, "context == null");
        boolean hasGoogleLocationServices = Utils.isOnClasspath(GOOGLE_LOCATION_SERVICES);
        if (Utils.isOnClasspath(GOOGLE_API_AVAILABILITY)) {
            hasGoogleLocationServices &= GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        }
        return LocationEngineProvider.getLocationEngine(context, hasGoogleLocationServices);
    }

    private static LocationEngine getLocationEngine(Context context, boolean isGoogle) {
        return isGoogle ? new LocationEngineProxy<LocationCallback>(new GoogleLocationEngineImpl(context.getApplicationContext())) : new LocationEngineProxy<LocationListener>(new MapboxFusedLocationEngineImpl(context.getApplicationContext()));
    }
}

