/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase.sqlgenerators;

import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.statement.core.UpdateStatement;

public class PortofinoPostgresUnlockDatabaseChangeLogGenerator
extends AbstractSqlGenerator<UnlockDatabaseChangeLogStatement> {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";

    public int getPriority() {
        return 5;
    }

    public boolean supports(UnlockDatabaseChangeLogStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(UnlockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(UnlockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String liquibaseSchema = database.getLiquibaseSchemaName();
        UpdateStatement releaseStatement = new UpdateStatement(liquibaseSchema, database.getDatabaseChangeLogLockTableName());
        releaseStatement.addNewColumnValue("locked", (Object)false);
        releaseStatement.addNewColumnValue("lockgranted", null);
        releaseStatement.addNewColumnValue("lockedby", null);
        releaseStatement.setWhereClause("id = 1");
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)releaseStatement, database);
    }
}

