/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase.sqlgenerators;

import com.manydesigns.portofino.liquibase.databases.GoogleCloudSQLDatabase;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.UpdateStatement;

public class GoogleCloudSQLLockDatabaseChangeLogGenerator
extends AbstractSqlGenerator<LockDatabaseChangeLogStatement> {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";

    public int getPriority() {
        return 5;
    }

    public boolean supports(LockDatabaseChangeLogStatement statement, Database database) {
        return database instanceof GoogleCloudSQLDatabase;
    }

    public ValidationErrors validate(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String liquibaseCatalog = database.getLiquibaseCatalogName();
        String liquibaseSchema = database.getLiquibaseSchemaName();
        UpdateStatement updateStatement = new UpdateStatement(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogLockTableName());
        updateStatement.addNewColumnValue("locked", (Object)true);
        updateStatement.addNewColumnValue("lockgranted", (Object)new Timestamp(new Date().getTime()));
        updateStatement.addNewColumnValue("lockedby", (Object)"Google Cloud SQL");
        updateStatement.setWhereClause(database.escapeColumnName(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogTableName(), "ID") + " = 1 AND " + database.escapeColumnName(liquibaseCatalog, liquibaseSchema, database.getDatabaseChangeLogTableName(), "LOCKED") + " = " + DataTypeFactory.getInstance().fromDescription("boolean", database).objectToSql((Object)false, database));
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)updateStatement, database);
    }
}

