/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.database.platforms.AbstractDatabasePlatform;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;

public class GoogleCloudSQLDatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String DESCRIPTION = "Google Cloud SQL";
    public static final String STANDARD_DRIVER_CLASS_NAME = "com.google.appengine.api.rdbms.AppEngineDriver";

    public GoogleCloudSQLDatabasePlatform() {
        super((Dialect)new MySQLDialect(), "jdbc:google:rdbms://<instance-name>/<database>");
        try {
            DriverManager.registerDriver((Driver)Class.forName("com.google.cloud.sql.Driver").newInstance());
        }
        catch (Exception e) {
            logger.debug("The driver to connect to Google Cloud SQL from a non-GAE application was not found", (Throwable)e);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return connectionProvider.getDatabaseProductName().contains("Google");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet rs = databaseMetaData.getCatalogs();
        ArrayList<String> schemaNames = new ArrayList<String>();
        try {
            while (rs.next()) {
                String schemaName = rs.getString("TABLE_CAT");
                schemaNames.add(schemaName);
            }
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rs);
        }
        return schemaNames;
    }

    public boolean isDialectAutodetected() {
        return false;
    }
}

