/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.elements.annotations.Status;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.dialect.Dialect;

public interface DatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static final String STATUS_CREATED = "created";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_DRIVER_NOT_FOUND = "driver not found";
    public static final String STATUS_DRIVER_ERROR = "driver error";

    public String getDescription();

    public String getStandardDriverClassName();

    public Dialect getHibernateDialect();

    public boolean isDialectAutodetected();

    public String getConnectionStringTemplate();

    @Status(red={"driver error"}, amber={"created", "driver not found"}, green={"ok"})
    public String getStatus();

    public void test();

    public boolean isApplicable(ConnectionProvider var1);

    public void shutdown(ConnectionProvider var1);

    public List<String[]> getSchemaNames(DatabaseMetaData var1) throws SQLException;
}

