/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.reflection;

import com.manydesigns.elements.annotations.Enabled;
import com.manydesigns.elements.annotations.Insertable;
import com.manydesigns.elements.annotations.MaxLength;
import com.manydesigns.elements.annotations.PrecisionScale;
import com.manydesigns.elements.annotations.Required;
import com.manydesigns.elements.annotations.Searchable;
import com.manydesigns.elements.annotations.Updatable;
import com.manydesigns.elements.annotations.impl.EnabledImpl;
import com.manydesigns.elements.annotations.impl.InsertableImpl;
import com.manydesigns.elements.annotations.impl.MaxLengthImpl;
import com.manydesigns.elements.annotations.impl.PrecisionScaleImpl;
import com.manydesigns.elements.annotations.impl.RequiredImpl;
import com.manydesigns.elements.annotations.impl.SearchableImpl;
import com.manydesigns.elements.annotations.impl.UpdatableImpl;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.reflection.AbstractAnnotatedAccessor;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnAccessor
extends AbstractAnnotatedAccessor
implements PropertyAccessor {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    protected final Column column;
    protected final PropertyAccessor nestedPropertyAccessor;
    public static final Logger logger = LoggerFactory.getLogger(ColumnAccessor.class);

    public ColumnAccessor(Column column, boolean inPk, boolean autoGenerated, PropertyAccessor nestedPropertyAccessor) {
        super(column.getAnnotations());
        this.column = column;
        this.nestedPropertyAccessor = nestedPropertyAccessor;
        this.annotations.put(Required.class, new RequiredImpl(!column.isNullable()));
        if (column.getLength() != null && column.getLength() > 0) {
            if (String.class.equals((Object)column.getActualJavaType())) {
                this.annotations.put(MaxLength.class, new MaxLengthImpl(column.getLength().intValue()));
            } else if (column.getScale() != null && column.getScale() >= 0) {
                this.annotations.put(PrecisionScale.class, new PrecisionScaleImpl(column.getLength().intValue(), column.getScale().intValue()));
            }
        }
        this.annotations.put(Enabled.class, new EnabledImpl(true));
        this.annotations.put(Updatable.class, new UpdatableImpl(!inPk));
        this.annotations.put(Insertable.class, new InsertableImpl(!column.isAutoincrement() && !autoGenerated));
        this.annotations.put(Searchable.class, new SearchableImpl(column.isSearchable()));
    }

    public String getName() {
        return this.column.getActualPropertyName();
    }

    public Class getType() {
        return this.column.getActualJavaType();
    }

    public int getModifiers() {
        return 1;
    }

    public Object get(Object obj) {
        if (this.nestedPropertyAccessor == null) {
            return ((Map)obj).get(this.column.getActualPropertyName());
        }
        return this.nestedPropertyAccessor.get(obj);
    }

    public void set(Object obj, Object value) {
        if (this.nestedPropertyAccessor == null) {
            ((Map)obj).put(this.column.getActualPropertyName(), value);
        } else {
            this.nestedPropertyAccessor.set(obj, value);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("column", (Object)this.column.getQualifiedName()).toString();
    }
}

