/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.code;

import com.manydesigns.portofino.code.AbstractCodeBase;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.CodeBaseWithSubscription;
import io.reactivex.subjects.Subject;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateCodeBase
extends AbstractCodeBase {
    private static final Logger logger = LoggerFactory.getLogger(AggregateCodeBase.class);
    protected final List<CodeBaseWithSubscription> codeBases = new CopyOnWriteArrayList<CodeBaseWithSubscription>();

    public AggregateCodeBase() {
        super(null);
    }

    public AggregateCodeBase(CodeBase parent, ClassLoader classLoader) {
        super(null, parent, classLoader);
    }

    @Override
    protected Class loadLocalClass(String className) throws IOException, ClassNotFoundException {
        for (CodeBaseWithSubscription c : this.codeBases) {
            try {
                Class aClass = c.codeBase.loadClass(className, CodeBase.SearchScope.LOCAL);
                if (aClass == null) continue;
                return aClass;
            }
            catch (ClassNotFoundException e) {
                logger.debug("Class " + className + " not found in codebase " + c.codeBase, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public URL findResource(String name) throws IOException {
        for (CodeBaseWithSubscription c : this.codeBases) {
            URL resource = c.codeBase.findResource(name);
            if (resource == null) continue;
            return resource;
        }
        if (this.parent != null) {
            return this.parent.findResource(name);
        }
        return null;
    }

    @Override
    public void clear(boolean recursively) throws Exception {
        super.clear(recursively);
        for (CodeBaseWithSubscription c : this.codeBases) {
            c.codeBase.clear(recursively);
        }
    }

    @Override
    public void close() {
        super.close();
        this.codeBases.forEach(c -> {
            c.subscription.dispose();
            c.codeBase.close();
        });
        this.codeBases.clear();
    }

    public void add(CodeBase codeBase) {
        this.codeBases.add(this.subscribeToCodeBase(codeBase));
        this.reloads.onNext(this.getClass());
    }

    protected CodeBaseWithSubscription subscribeToCodeBase(CodeBase codeBase) {
        return new CodeBaseWithSubscription(codeBase, codeBase.getReloads().subscribe(arg_0 -> ((Subject)this.reloads).onNext(arg_0)));
    }

    public boolean remove(CodeBase codeBase) {
        return this.codeBases.removeIf(c -> {
            if (c.codeBase.equals(codeBase)) {
                c.subscription.dispose();
                this.reloads.onNext(this.getClass());
                return true;
            }
            return false;
        });
    }

    public boolean replace(CodeBase oldCodeBase, CodeBase newCodeBase) {
        ListIterator<CodeBaseWithSubscription> iterator = this.codeBases.listIterator();
        while (iterator.hasNext()) {
            CodeBaseWithSubscription next = iterator.next();
            if (!next.codeBase.equals(oldCodeBase)) continue;
            next.subscription.dispose();
            iterator.remove();
            iterator.add(this.subscribeToCodeBase(newCodeBase));
            this.reloads.onNext(this.getClass());
            return true;
        }
        return false;
    }
}

