/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.code;

import com.manydesigns.portofino.code.CodeBase;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileObject;

public abstract class AbstractCodeBase
implements CodeBase {
    protected CodeBase parent;
    protected final ConcurrentMap<String, WeakReference<Class>> knownClasses = new ConcurrentHashMap<String, WeakReference<Class>>();
    protected final Subject<Class> reloads = PublishSubject.create();
    protected FileObject root;
    protected ClassLoader classLoader;

    public AbstractCodeBase(FileObject root) {
        this.root = root;
    }

    public AbstractCodeBase(FileObject root, CodeBase parent, ClassLoader classLoader) {
        this(root);
        this.parent = parent;
        this.classLoader = classLoader;
        if (parent != null) {
            parent.getReloads().subscribe(c -> {
                this.parentClassReloaded((Class)c);
                this.reloads.onNext(c);
            });
        }
    }

    protected void parentClassReloaded(Class c) throws Exception {
        this.clear();
    }

    @Override
    public Class loadClass(String className, CodeBase.SearchScope searchScope) throws IOException, ClassNotFoundException {
        Class localClass = this.loadLocalClass(className);
        if (localClass != null) {
            WeakReference oldClass = (WeakReference)this.knownClasses.get(className);
            boolean shouldSignalReload = oldClass != null && oldClass.get() != localClass;
            this.knownClasses.put(className, new WeakReference<Class>(localClass));
            if (shouldSignalReload) {
                this.reloads.onNext((Object)localClass);
            }
            return localClass;
        }
        if (searchScope == CodeBase.SearchScope.LOCAL) {
            throw new ClassNotFoundException(className);
        }
        if (this.parent != null) {
            return this.parent.loadClass(className, searchScope);
        }
        if (searchScope == CodeBase.SearchScope.LOCAL_PARENT) {
            throw new ClassNotFoundException(className);
        }
        return this.getClassLoader().loadClass(className);
    }

    protected abstract Class loadLocalClass(String var1) throws IOException, ClassNotFoundException;

    @Override
    public CodeBase getParent() {
        return this.parent;
    }

    @Override
    public Subject<Class> getReloads() {
        return this.reloads;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void clear() throws Exception {
        if (this.parent != null) {
            this.parent.clear();
        }
    }

    @Override
    public void close() {
        try {
            if (this.parent != null) {
                this.parent.close();
            }
        }
        finally {
            this.reloads.onComplete();
        }
    }

    @Override
    public FileObject getRoot() {
        return this.root;
    }
}

