/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.code;

import com.manydesigns.portofino.code.CodeBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCodeBase
implements CodeBase {
    protected org.apache.commons.vfs2.FileObject root;
    protected CodeBase parent;
    protected ClassLoader classLoader;
    protected JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    protected DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector();
    protected InMemoryFileManager fileManager;
    protected VFSClassloader vfsClassloader;
    private static final Logger logger = LoggerFactory.getLogger(JavaCodeBase.class);

    public JavaCodeBase(org.apache.commons.vfs2.FileObject root) {
        this.root = root;
    }

    public JavaCodeBase(org.apache.commons.vfs2.FileObject root, CodeBase parent, ClassLoader classLoader) throws IOException {
        this.root = root;
        this.parent = parent;
        this.classLoader = classLoader;
        this.resetFileManagerAndClassLoader();
    }

    public void resetFileManagerAndClassLoader() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.close();
        }
        this.fileManager = new InMemoryFileManager(this.compiler.getStandardFileManager(this.diagnosticCollector, null, null));
        this.vfsClassloader = new VFSClassloader(this.fileManager.directory, this.getClassLoader());
    }

    public JavaCodeBase(org.apache.commons.vfs2.FileObject root, CodeBase parent) throws IOException {
        this(root, parent, parent != null ? parent.getClassLoader() : null);
    }

    @Override
    public Class loadClass(String className) throws IOException, ClassNotFoundException {
        String resourceName = JavaCodeBase.classNameToPath(className);
        org.apache.commons.vfs2.FileObject fileObject = this.root.resolveFile(resourceName + ".class");
        if (fileObject.exists()) {
            return this.loadClassFile(fileObject, className);
        }
        fileObject = this.root.resolveFile(resourceName + ".java");
        if (fileObject.exists()) {
            return this.loadJavaFile(fileObject, className);
        }
        if (this.parent != null) {
            return this.parent.loadClass(className);
        }
        return this.getClassLoader().loadClass(className);
    }

    public Class loadClassFile(org.apache.commons.vfs2.FileObject location, String name) throws FileSystemException, ClassNotFoundException {
        return new VFSClassloader(location, this.getClassLoader()).loadClass(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    public Class loadJavaFile(org.apache.commons.vfs2.FileObject fileObject, String name) throws ClassNotFoundException {
        try {
            VFSJavaFileObject javaFile = new VFSJavaFileObject(JavaFileObject.Kind.SOURCE, fileObject, name);
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, null, null, null, Collections.singletonList(javaFile));
            if (task.call().booleanValue()) {
                return this.vfsClassloader.loadClass(name);
            }
            logger.warn("Compilation errors");
            throw new ClassNotFoundException(name);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    protected void listClassFiles(String packageName, Collection<JavaFileObject> list) throws IOException {
        Enumeration<URL> resources = this.getClassLoader().getResources(packageName.replace('.', '/'));
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            org.apache.commons.vfs2.FileObject fileObject = VFS.getManager().resolveFile(url.toString());
            if (!fileObject.exists() || fileObject.getType() != FileType.FOLDER) continue;
            for (org.apache.commons.vfs2.FileObject child : fileObject.getChildren()) {
                if (child.getType() != FileType.FILE || !"class".equalsIgnoreCase(child.getName().getExtension())) continue;
                try {
                    String binaryName = FilenameUtils.removeExtension((String)child.getName().getPath()).replace(File.separatorChar, '.').replace('/', '.');
                    if (binaryName.startsWith(".")) {
                        binaryName = binaryName.substring(1);
                    }
                    list.add(new VFSJavaFileObject(JavaFileObject.Kind.CLASS, child, binaryName));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    protected void listJavaFiles(String packageName, List<JavaFileObject> list) throws IOException {
        org.apache.commons.vfs2.FileObject pkgFile = this.root.resolveFile(JavaCodeBase.classNameToPath(packageName));
        if (pkgFile.exists() && pkgFile.getType() == FileType.FOLDER) {
            for (org.apache.commons.vfs2.FileObject child : pkgFile.getChildren()) {
                if (child.getType() != FileType.FILE || !"java".equalsIgnoreCase(child.getName().getExtension())) continue;
                try {
                    String className = FilenameUtils.removeExtension((String)child.getName().getBaseName());
                    String binaryName = packageName + "." + className;
                    list.add(new VFSJavaFileObject(JavaFileObject.Kind.SOURCE, child, binaryName));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        if (this.parent instanceof JavaCodeBase) {
            ((JavaCodeBase)this.parent).listJavaFiles(packageName, list);
        }
    }

    public static String classNameToPath(String name) {
        return name.replace('.', '/');
    }

    protected static URI sanitizeUri(URI uri) throws URISyntaxException {
        String schemeSpecificPart;
        int lastIndexOf;
        if (uri.getPath() == null && (lastIndexOf = (schemeSpecificPart = uri.getSchemeSpecificPart()).lastIndexOf(33)) > 0) {
            uri = new URI(uri.getScheme(), uri.getHost(), schemeSpecificPart.substring(lastIndexOf + 1), uri.getFragment());
        }
        return uri;
    }

    @Override
    public void close() {
        if (this.fileManager != null) {
            try {
                this.fileManager.close();
            }
            catch (IOException e) {
                logger.warn("Could not close file manager", (Throwable)e);
            }
        }
    }

    @Override
    public org.apache.commons.vfs2.FileObject getRoot() {
        return this.root;
    }

    @Override
    public void clear() throws Exception {
        if (this.parent != null) {
            this.parent.clear();
        }
        this.resetFileManagerAndClassLoader();
    }

    public class InMemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        public final org.apache.commons.vfs2.FileObject directory;

        public InMemoryFileManager(JavaFileManager fileManager) throws IOException {
            super(fileManager);
            FileSystemManager fsManager = VFS.getManager();
            this.directory = fsManager.resolveFile("ram://" + UUID.randomUUID().toString());
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            if (kind == JavaFileObject.Kind.SOURCE) {
                org.apache.commons.vfs2.FileObject source = JavaCodeBase.this.root.resolveFile(JavaCodeBase.classNameToPath(className) + ".java");
                return new VFSJavaFileObject(URI.create(source.getPublicURIString()), kind, source, className);
            }
            return super.getJavaFileForInput(location, className, kind);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            String binaryName;
            if (file instanceof VFSJavaFileObject && (binaryName = ((VFSJavaFileObject)file).getBinaryName()) != null) {
                return binaryName;
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            ArrayList<JavaFileObject> list = new ArrayList<JavaFileObject>();
            Iterable<JavaFileObject> superList = super.list(location, packageName, kinds, recurse);
            for (JavaFileObject fileObject : superList) {
                list.add(fileObject);
            }
            if (kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
                JavaCodeBase.this.listJavaFiles(packageName, list);
            }
            if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                JavaCodeBase.this.listClassFiles(packageName, list);
            }
            return list;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return new CompiledClass(super.getJavaFileForOutput(location, className, kind, sibling), className);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.directory.close();
        }

        public class CompiledClass
        extends ForwardingJavaFileObject<JavaFileObject> {
            public final String name;

            public CompiledClass(JavaFileObject fileObject, String name) {
                super(fileObject);
                this.name = name;
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                org.apache.commons.vfs2.FileObject fileObject = InMemoryFileManager.this.directory.resolveFile(JavaCodeBase.classNameToPath(this.name) + ".class");
                if (!fileObject.exists()) {
                    fileObject.createFile();
                }
                return fileObject.getContent().getOutputStream();
            }
        }
    }

    public static class VFSJavaFileObject
    extends SimpleJavaFileObject {
        protected final org.apache.commons.vfs2.FileObject source;
        protected final String binaryName;

        public VFSJavaFileObject(URI uri, JavaFileObject.Kind kind, org.apache.commons.vfs2.FileObject source, String binaryName) {
            super(uri, kind);
            this.source = source;
            this.binaryName = binaryName;
        }

        public VFSJavaFileObject(JavaFileObject.Kind kind, org.apache.commons.vfs2.FileObject source, String binaryName) throws URISyntaxException {
            super(JavaCodeBase.sanitizeUri(new URI(source.getName().getURI())), kind);
            this.source = source;
            this.binaryName = binaryName;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.source.getContent().getInputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            InputStream input = this.openInputStream();
            try {
                String string = IOUtils.toString((InputStream)input);
                return string;
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }

        public org.apache.commons.vfs2.FileObject getSource() {
            return this.source;
        }

        public String getBinaryName() {
            return this.binaryName;
        }
    }

    public static class VFSClassloader
    extends ClassLoader {
        protected final org.apache.commons.vfs2.FileObject fileObject;

        public VFSClassloader(org.apache.commons.vfs2.FileObject fileObject) {
            this(fileObject, Thread.currentThread().getContextClassLoader());
        }

        public VFSClassloader(org.apache.commons.vfs2.FileObject fileObject, ClassLoader parent) {
            super(parent);
            this.fileObject = fileObject;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            org.apache.commons.vfs2.FileObject fileObject = this.fileObject;
            synchronized (fileObject) {
                try {
                    org.apache.commons.vfs2.FileObject classFile = this.fileObject.getType() == FileType.FILE ? this.fileObject : this.fileObject.resolveFile(JavaCodeBase.classNameToPath(name) + ".class");
                    try (InputStream inputStream = classFile.getContent().getInputStream();){
                        byte[] code = IOUtils.toByteArray((InputStream)inputStream);
                        Class<?> clazz = this.defineClass(name, code);
                        return clazz;
                    }
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
        }

        public Class<?> defineClass(String name, byte[] code) throws ClassNotFoundException {
            try {
                return this.defineClass(null, code, 0, code.length);
            }
            catch (LinkageError e) {
                throw new ClassNotFoundException(name, e);
            }
        }
    }
}

