/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import com.manydesigns.elements.blobs.FileBean;
import com.manydesigns.elements.blobs.MultipartWrapper;
import com.manydesigns.elements.servlet.MutableHttpSession;
import com.manydesigns.elements.servlet.MutableServletContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.ArrayUtils;

public class MutableHttpServletRequest
implements HttpServletRequest,
MultipartWrapper {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public final Map<String, Object> attributeMap;
    public final Map<String, String[]> parameterMap;
    public final Map<String, String[]> headerMap;
    public final Map<String, FileItem> fileItemMap;
    public final List<Locale> locales;
    private String method;
    private String contextPath = "";
    private String servletPath;
    private String requestURI;
    private String queryString;
    private String scheme;
    private String serverName;
    private int serverPort;
    private String contentType;
    private String characterEncoding = Charset.defaultCharset().name();
    private MutableServletContext servletContext;
    private MutableHttpSession session;

    public MutableHttpServletRequest() {
        this(new MutableServletContext());
    }

    public MutableHttpServletRequest(MutableServletContext servletContext) {
        this.servletContext = servletContext;
        this.attributeMap = new HashMap<String, Object>();
        this.headerMap = new HashMap<String, String[]>();
        this.parameterMap = new HashMap<String, String[]>();
        this.fileItemMap = new HashMap<String, FileItem>();
        this.locales = new ArrayList<Locale>();
        this.locales.add(Locale.getDefault());
    }

    public void addParameter(String name, String value) {
        Object[] oldValues = this.parameterMap.get(name);
        String[] newValues = (String[])ArrayUtils.add((Object[])oldValues, (Object)value);
        this.parameterMap.put(name, newValues);
    }

    public void setParameter(String key, String ... values) {
        this.parameterMap.put(key, values);
    }

    public boolean addFileItem(String name, FileItem item) {
        FileItem inMap = this.fileItemMap.putIfAbsent(name, item);
        return inMap == item;
    }

    public FileItem getFileItem(String name) {
        return this.fileItemMap.get(name);
    }

    public void setFileItem(String key, FileItem value) {
        this.fileItemMap.put(key, value);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setContextPath(String context) {
        this.contextPath = context;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void makeMultipart() {
        this.setMethod("POST");
        this.setContentType("multipart/form-data");
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public void build(HttpServletRequest request, File tempDir, long maxPostSize) {
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.fileItemMap.keySet());
    }

    @Override
    public FileBean getFileParameterValue(String name) {
        final FileItem item = this.fileItemMap.get(name);
        if (item == null || (item.getName() == null || item.getName().length() == 0) && item.getSize() == 0L) {
            return null;
        }
        String filename = item.getName();
        return new FileBean(null, item.getContentType(), filename, this.getCharacterEncoding()){

            @Override
            public long getSize() {
                return item.getSize();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return item.getInputStream();
            }

            @Override
            public void delete() {
                item.delete();
            }
        };
    }

    @Override
    public HttpServletRequestWrapper wrapRequest(HttpServletRequest request) {
        return null;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Object getAttribute(String s) {
        return this.attributeMap.get(s);
    }

    public void setAttribute(String s, Object o) {
        this.attributeMap.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributeMap.remove(s);
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public long getDateHeader(String s) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String s) {
        String[] values = this.headerMap.get(s);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getHeaders(String s) {
        String[] values = this.headerMap.get(s);
        if (values == null) {
            return null;
        }
        return Collections.enumeration(Arrays.asList(values));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public int getIntHeader(String s) {
        throw new UnsupportedOperationException();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String s) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        if (create) {
            MutableHttpServletRequest mutableHttpServletRequest = this;
            synchronized (mutableHttpServletRequest) {
                if (this.session == null) {
                    this.session = new MutableHttpSession(this.servletContext);
                }
            }
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String s) {
        this.characterEncoding = s;
    }

    public int getContentLength() {
        return -1;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getRealPath(String s) {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String s) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public MutableServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        return null;
    }
}

