/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMap
implements Map<String, Object> {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected Method attributeNamesGetter;
    protected Method attributeGetter;
    protected Method attributeSetter;
    protected Object wrappedObject;
    public static final Logger logger = LoggerFactory.getLogger(AttributeMap.class);

    public static AttributeMap createAttributeMap(ServletRequest request) {
        return new AttributeMap(ServletRequest.class, request);
    }

    public static AttributeMap createAttributeMap(HttpSession session) {
        return new AttributeMap(HttpSession.class, session);
    }

    public static AttributeMap createAttributeMap(ServletContext servletContext) {
        return new AttributeMap(ServletContext.class, servletContext);
    }

    protected AttributeMap(Class clazz, Object wrappedObject) {
        this.wrappedObject = wrappedObject;
        try {
            this.attributeNamesGetter = clazz.getMethod("getAttributeNames", new Class[0]);
            this.attributeGetter = clazz.getMethod("getAttribute", String.class);
            this.attributeSetter = clazz.getMethod("setAttribute", String.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Required method not found", e);
        }
    }

    protected Enumeration getAttributeNames() {
        if (this.wrappedObject == null) {
            logger.debug("Null wrapped object");
            return null;
        }
        try {
            return (Enumeration)this.attributeNamesGetter.invoke(this.wrappedObject, new Object[0]);
        }
        catch (Throwable e) {
            logger.warn("Invocation error", e);
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }

    protected Object getAttribute(String name) {
        if (this.wrappedObject == null) {
            logger.debug("Null wrapped object");
            return null;
        }
        try {
            return this.attributeGetter.invoke(this.wrappedObject, name);
        }
        catch (Throwable e) {
            logger.warn("Invocation error", e);
            return null;
        }
    }

    protected void setAttribute(String name, Object value) {
        if (this.wrappedObject == null) {
            logger.debug("Null wrapped object");
            return;
        }
        try {
            this.attributeSetter.invoke(this.wrappedObject, name, value);
        }
        catch (Throwable e) {
            logger.warn("Invocation error", e);
        }
    }

    @Override
    public int size() {
        int counter = 0;
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++counter;
        }
        return counter;
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object keyValue = this.getAttribute(key);
            if (keyValue != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.getAttribute((String)key);
    }

    @Override
    public Object put(String key, @Nullable Object o) {
        Object oldValue = this.get(key);
        this.setAttribute(key, o);
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.put((String)key, (Object)null);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.add(key);
        }
        return result;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.getAttribute(key);
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.getAttribute(key);
            Entry entry = new Entry(key, value);
            result.add(entry);
        }
        return result;
    }

    static class Entry
    implements Map.Entry<String, Object> {
        final String key;
        Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object o) {
            Object oldValue = this.value;
            this.value = o;
            return oldValue;
        }
    }
}

