/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobUtils;
import com.manydesigns.elements.blobs.Repository;
import com.manydesigns.elements.blobs.RepositoryRegistry;
import com.manydesigns.elements.blobs.SimpleBlobManager;
import com.manydesigns.elements.util.RandomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class HierarchicalBlobManager
extends SimpleBlobManager {
    public HierarchicalBlobManager(File blobsDir, String metaFileNamePattern, String dataFileNamePattern) {
        super(blobsDir, metaFileNamePattern, dataFileNamePattern);
    }

    @Override
    protected File getMetaFile(String code) {
        File dir = this.getBlobSubdir(code);
        return RandomUtil.getCodeFile(dir, this.metaFileNamePattern, code);
    }

    @Override
    protected File getDataFile(String code) {
        File dir = this.getBlobSubdir(code);
        return RandomUtil.getCodeFile(dir, this.dataFileNamePattern, code);
    }

    protected File getBlobSubdir(String code) {
        return new File(new File(new File(this.blobsDir, code.substring(0, 2)), code.substring(2, 4)), code.substring(4, 6));
    }

    @Override
    public InputStream openStream(Blob blob) throws IOException {
        this.ensureValidCode(blob.getCode());
        if (blob.getRepository() != null) {
            Repository repository = RepositoryRegistry.getInstance().getRepository(blob.getRepository());
            repository.load(blob);
        } else {
            FileInputStream fileInputStream = new FileInputStream(this.getDataFile(blob.getCode()));
            if (blob.isEncrypted().booleanValue()) {
                blob.setInputStream(BlobUtils.decrypt(fileInputStream, blob.getEncryptionType()));
            } else {
                blob.setInputStream(fileInputStream);
            }
        }
        return blob.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Blob blob) throws IOException {
        block10: {
            if (blob.getRepository() != null) {
                this.ensureValidCode(blob.getCode());
                Repository repository = RepositoryRegistry.getInstance().getRepository(blob.getRepository());
                repository.save(blob);
                File metaFile = this.getMetaFile(blob.getCode());
                if (!metaFile.getParentFile().isDirectory()) {
                    metaFile.getParentFile().mkdirs();
                }
                try (FileOutputStream out = new FileOutputStream(metaFile);){
                    blob.getMetaProperties().store(out, "Remote Blob code #" + blob.getCode());
                    break block10;
                }
                finally {
                    blob.dispose();
                }
            }
            super.save(blob);
        }
    }

    @Override
    public boolean delete(Blob blob) {
        if (!blob.isPropertiesLoaded()) {
            try {
                this.loadMetadata(blob);
            }
            catch (IOException e) {
                logger.warn("Cound load metadata ", (Throwable)e);
            }
        }
        if (blob.getRepository() != null) {
            boolean success;
            String code = blob.getCode();
            this.ensureValidCode(code);
            File metaFile = this.getMetaFile(code);
            try {
                Repository repository = RepositoryRegistry.getInstance().getRepository(blob.getRepository());
                success = repository.delete(blob);
            }
            catch (Exception e) {
                logger.warn("Cound not delete file from repository ", (Throwable)e);
                success = false;
            }
            try {
                success = success && metaFile.delete();
            }
            catch (Exception e) {
                logger.warn("Cound not delete meta file", (Throwable)e);
                success = false;
            }
            return success;
        }
        return super.delete(blob);
    }
}

