/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blob {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(Blob.class);
    public static final String FILENAME_PROPERTY = "filename";
    public static final String CONTENT_TYPE_PROPERTY = "content.type";
    public static final String SIZE_PROPERTY = "size";
    public static final String CREATE_TIMESTAMP_PROPERTY = "create.timestamp";
    public static final String CHARACTER_ENCODING_PROPERTY = "character.encoding";
    public static final String REPOSITORY_PROPERTY = "repository";
    public static final String REPOSITORY_ID_PROPERTY = "repository.id";
    public static final String ENCRYPTION_PROPERTY = "encryption.type";
    public static final String CUSTOM_DATA_PROPERTY = "custom.data";
    protected final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    protected final String code;
    protected String contentType;
    protected String filename;
    protected long size;
    protected DateTime createTimestamp;
    protected String characterEncoding;
    protected InputStream inputStream;
    protected boolean propertiesLoaded;
    protected String encryptionType;
    protected String repository;
    protected String repositoryId;
    protected Map customData;

    public Blob(String code) {
        this.code = code;
    }

    protected void safeSetProperty(Properties metaProperties, String key, String value) {
        if (value == null) {
            metaProperties.remove(key);
        } else {
            metaProperties.setProperty(key, value);
        }
    }

    public Properties getMetaProperties() throws IOException {
        Properties metaProperties = new Properties();
        if (this.createTimestamp == null) {
            this.createTimestamp = new DateTime();
        }
        this.safeSetProperty(metaProperties, FILENAME_PROPERTY, this.filename);
        this.safeSetProperty(metaProperties, CONTENT_TYPE_PROPERTY, this.contentType);
        this.safeSetProperty(metaProperties, SIZE_PROPERTY, Long.toString(this.size));
        this.safeSetProperty(metaProperties, CREATE_TIMESTAMP_PROPERTY, this.formatter.print((ReadableInstant)this.createTimestamp));
        this.safeSetProperty(metaProperties, CHARACTER_ENCODING_PROPERTY, this.characterEncoding);
        this.safeSetProperty(metaProperties, REPOSITORY_PROPERTY, this.repository);
        this.safeSetProperty(metaProperties, REPOSITORY_ID_PROPERTY, this.repositoryId);
        this.safeSetProperty(metaProperties, ENCRYPTION_PROPERTY, this.encryptionType);
        this.safeSetProperty(metaProperties, CUSTOM_DATA_PROPERTY, this.getSerializedCustomData());
        return metaProperties;
    }

    public void setMetaProperties(Properties metaProperties) throws IOException {
        this.filename = metaProperties.getProperty(FILENAME_PROPERTY);
        this.contentType = metaProperties.getProperty(CONTENT_TYPE_PROPERTY);
        this.size = Long.parseLong(metaProperties.getProperty(SIZE_PROPERTY));
        this.createTimestamp = this.formatter.parseDateTime(metaProperties.getProperty(CREATE_TIMESTAMP_PROPERTY));
        this.characterEncoding = metaProperties.getProperty(CHARACTER_ENCODING_PROPERTY);
        this.repository = metaProperties.getProperty(REPOSITORY_PROPERTY);
        this.repositoryId = metaProperties.getProperty(REPOSITORY_ID_PROPERTY);
        this.encryptionType = metaProperties.getProperty(ENCRYPTION_PROPERTY);
        this.setCustomData(metaProperties.getProperty(CUSTOM_DATA_PROPERTY));
        this.propertiesLoaded = true;
    }

    public String getCode() {
        return this.code;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public DateTime getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(DateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean isPropertiesLoaded() {
        return this.propertiesLoaded;
    }

    public void setPropertiesLoaded(boolean propertiesLoaded) {
        this.propertiesLoaded = propertiesLoaded;
    }

    public void dispose() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public Boolean isEncrypted() {
        return this.encryptionType != null;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Map getCustomData() {
        return this.customData;
    }

    public void setCustomData(Map customData) {
        this.customData = customData;
    }

    public String getSerializedCustomData() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this.customData);
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setCustomData(String customData) {
        if (customData != null && !customData.equals("")) {
            try {
                logger.debug("Reading customData from: " + customData);
                ObjectMapper mapper = new ObjectMapper();
                this.customData = (Map)mapper.readValue(customData, Map.class);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blob blob = (Blob)o;
        return this.code != null ? this.code.equals(blob.code) : blob.code == null;
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }
}

