/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xml;

import com.manydesigns.elements.xml.XhtmlFragment;
import com.manydesigns.elements.xml.XmlBuffer;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XhtmlBuffer
extends XmlBuffer
implements XhtmlFragment {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static String[] XHTML_EMPTY_TAG_ALLOWED_LIST = new String[]{"area", "base", "br", "col", "hr", "img", "input", "link", "meta", "param"};

    public XhtmlBuffer() {
        this(new StringWriter());
    }

    public XhtmlBuffer(Writer writer) {
        super(writer);
        this.allowedEmptyTags = XHTML_EMPTY_TAG_ALLOWED_LIST;
    }

    public void writeAnchor(String href, String text) {
        this.writeAnchor(href, text, null, null);
    }

    public void writeNbsp() {
        this.writeNoHtmlEscape("&nbsp;");
    }

    public void writeAnchor(String href, String text, String classStr, String title) {
        this.openElement("a");
        if (href != null) {
            this.addAttribute("href", href);
        }
        if (classStr != null) {
            this.addAttribute("class", classStr);
        }
        if (title != null) {
            this.addAttribute("title", title);
        }
        this.write(text);
        this.closeElement("a");
    }

    public void writeCaption(String text) {
        this.openElement("caption");
        this.write(text);
        this.closeElement("caption");
    }

    public void writeLegend(String text, @Nullable String htmlClass) {
        this.openElement("legend");
        this.addAttribute("class", htmlClass);
        this.write(text);
        this.closeElement("legend");
    }

    public void writeLabel(String text, String forId, String htmlClass) {
        this.openElement("label");
        if (forId != null) {
            this.addAttribute("for", forId);
        }
        this.addAttribute("class", htmlClass);
        this.write(text);
        this.closeElement("label");
    }

    public void writeBr() {
        this.writeNoHtmlEscape("<br />");
    }

    public void writeDoctype() {
        this.writeDoctype("html", "PUBLIC", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
    }

    public void writeH1(String title) {
        this.openElement("h1");
        this.write(title);
        this.closeElement("h1");
    }

    public void writeH2(String title) {
        this.openElement("h2");
        this.write(title);
        this.closeElement("h2");
    }

    public void writeHr() {
        this.openElement("hr");
        this.closeElement("hr");
    }

    public void writeInputCheckbox(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked) {
        this.writeInputCheckbox(id, name, value, checked, false, null);
    }

    public void writeInputCheckbox(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked, boolean disabed, @Nullable String cssClass) {
        this.openElement("input");
        this.addAttribute("id", id);
        this.addAttribute("type", "checkbox");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        if (checked) {
            this.addAttribute("checked", "checked");
        }
        if (disabed) {
            this.addAttribute("disabled", "disabled");
        }
        if (cssClass != null) {
            this.addAttribute("class", cssClass);
        }
        this.closeElement("input");
    }

    public void writeInputCheckbox(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked, boolean disabed, @Nullable String cssClass, @Nullable String title) {
        this.openElement("input");
        this.addAttribute("id", id);
        this.addAttribute("type", "checkbox");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        if (checked) {
            this.addAttribute("checked", "checked");
        }
        if (disabed) {
            this.addAttribute("disabled", "disabled");
        }
        if (cssClass != null) {
            this.addAttribute("class", cssClass);
        }
        if (title != null) {
            this.addAttribute("title", title);
        }
        this.closeElement("input");
    }

    public void writeInputHidden(String name, String value) {
        this.openElement("input");
        this.addAttribute("type", "hidden");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        this.closeElement("input");
    }

    public void writeInputHidden(String id, String name, String value) {
        this.openElement("input");
        this.addAttribute("type", "hidden");
        this.addAttribute("id", id);
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        this.closeElement("input");
    }

    public void writeInputRadio(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked) {
        this.writeInputRadio(id, name, value, checked, false, null);
    }

    public void writeInputRadio(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked, boolean disabled) {
        this.writeInputRadio(id, name, value, checked, disabled, null);
    }

    public void writeInputRadio(@Nullable String id, @Nullable String name, @Nullable String value, boolean checked, boolean disabled, @Nullable String onClickEvent) {
        this.openElement("input");
        this.addAttribute("type", "radio");
        this.addAttribute("id", id);
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        if (checked) {
            this.addAttribute("checked", "checked");
        }
        if (disabled) {
            this.addAttribute("disabled", "disabled");
        }
        this.addAttribute("onclick", onClickEvent);
        this.closeElement("input");
    }

    public void writeInputSubmit(String name, String value, @Nullable String onSubmit) {
        this.openElement("input");
        this.addAttribute("type", "submit");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        this.addAttribute("class", "submit");
        this.addAttribute("onclick", onSubmit);
        this.closeElement("input");
    }

    public void writeInputText(@Nullable String id, @Nullable String name, String value, String htmlClass, @Nullable Integer size, @Nullable Integer maxLength) {
        this.writeInputText(id, name, value, null, htmlClass, size, maxLength);
    }

    public void writeInputText(@Nullable String id, @Nullable String name, String value, @Nullable String placeholder, String htmlClass, @Nullable Integer size, @Nullable Integer maxLength) {
        this.openElement("input");
        this.addAttribute("id", id);
        this.addAttribute("type", "text");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        if (placeholder != null) {
            this.addAttribute("placeholder", placeholder);
        }
        if (size != null) {
            this.addAttribute("size", Integer.toString(size));
            htmlClass = StringUtils.defaultString((String)htmlClass) + " mde-text-field-with-explicit-size";
        }
        this.addAttribute("class", htmlClass);
        if (maxLength != null) {
            this.addAttribute("maxlength", Integer.toString(maxLength));
        }
        this.closeElement("input");
    }

    public void writeInputNumber(@Nullable String id, @Nullable String name, String value, @Nullable String placeholder, String htmlClass, @Nullable Integer size, @Nullable Integer maxLength, @Nullable BigDecimal maxValue, @Nullable BigDecimal minValue, @Nullable Integer step) {
        this.openElement("input");
        this.addAttribute("id", id);
        this.addAttribute("type", "text");
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        if (minValue != null) {
            this.addAttribute("min", minValue.toString());
        }
        if (maxValue != null) {
            this.addAttribute("max", maxValue.toString());
        }
        if (step != null) {
            this.addAttribute("step", Integer.toString(step));
        }
        if (placeholder != null) {
            this.addAttribute("placeholder", placeholder);
        }
        if (size != null) {
            this.addAttribute("size", Integer.toString(size));
            htmlClass = StringUtils.defaultString((String)htmlClass) + " mde-text-field-with-explicit-size";
        }
        this.addAttribute("class", htmlClass);
        if (maxLength != null) {
            this.addAttribute("maxlength", Integer.toString(maxLength));
        }
        this.closeElement("input");
    }

    public void writeOption(String value, boolean selected, String text) {
        this.openElement("option");
        this.addAttribute("value", value);
        if (selected) {
            this.addAttribute("selected", "selected");
        }
        this.write(text);
        this.closeElement("option");
    }

    public void writeParagraph(String value) {
        this.openElement("p");
        this.write(value);
        this.closeElement("p");
    }

    public void writeJavaScript(String script) {
        this.openElement("script");
        this.addAttribute("type", "text/javascript");
        this.writeNoHtmlEscape(script);
        this.closeElement("script");
    }

    public void writeInputFile(String id, String name, String value, boolean disabled) {
        this.openElement("input");
        this.addAttribute("type", "file");
        this.addAttribute("id", id);
        this.addAttribute("name", name);
        this.addAttribute("value", value);
        this.addAttribute("class", "text file");
        this.addAttribute("data-show-preview", "false");
        this.addAttribute("data-show-upload", "false");
        if (disabled) {
            this.addAttribute("disabled", "disabled");
        }
        this.closeElement("input");
        String script = "$('#" + StringEscapeUtils.escapeJavaScript((String)id) + "').fileinput({'showUpload':false, 'previewFileType':'text' , 'browseLabel':'' , 'removeLabel':''}); ";
        if (disabled) {
            script = script + "$('#" + StringEscapeUtils.escapeJavaScript((String)id) + "').fileinput('disable');";
        }
        this.writeJavaScript(script);
    }

    public void writeInputFile(String id, String name, boolean disabled) {
        this.writeInputFile(id, name, null, disabled);
    }

    public void writeImage(String src, String alt, String title, String id, String htmlClass) {
        this.openElement("img");
        this.addAttribute("src", src);
        this.addAttribute("alt", alt);
        this.addAttribute("class", htmlClass);
        this.addAttribute("id", id);
        this.addAttribute("title", title);
        this.closeElement("img");
    }

    public void writeLink(String rel, String type, String href) {
        this.openElement("link");
        this.addAttribute("rel", rel);
        this.addAttribute("type", type);
        this.addAttribute("href", href);
        this.closeElement("link");
    }

    public void writeStyle(String body) {
        this.openElement("style");
        this.write(body);
        this.closeElement("style");
    }

    public void openFormElement(String id, String method, String action, String htmlClass) {
        this.openElement("form");
        this.addAttribute("id", id);
        this.addAttribute("method", method);
        this.addAttribute("action", action);
        this.addAttribute("class", htmlClass);
    }

    public void closeFormElement() {
        this.closeElement("form");
    }

    @Override
    public String escape(String s) {
        return StringEscapeUtils.escapeHtml((String)s);
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.write(this);
    }
}

