/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import com.manydesigns.elements.fields.helpers.FieldsManager;
import com.manydesigns.elements.util.ReflectionUtil;
import org.slf4j.Logger;

public class InstanceBuilder<T> {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    private Class<T> clazz;
    private Class defaultImplClass;
    private Logger logger;

    public InstanceBuilder(Class<T> iface, Class<? extends T> defaultImplClass, Logger logger) {
        this.clazz = iface;
        this.defaultImplClass = defaultImplClass;
        this.logger = logger;
    }

    public T createInstance(String managerClassName) {
        Class managerClass = ReflectionUtil.loadClass(managerClassName);
        if (managerClass == null) {
            this.logger.warn("Cannot load class: {}", (Object)managerClassName);
            managerClass = this.defaultImplClass;
        }
        if (!this.clazz.isAssignableFrom(managerClass)) {
            this.logger.warn("Cannot use as {}: {}", (Object)this.clazz.getName(), (Object)managerClassName);
            managerClass = this.defaultImplClass;
        }
        this.logger.debug("Using class: {}", (Object)managerClass.getName());
        Object instance = ReflectionUtil.newInstance(managerClass);
        if (instance == null) {
            this.logger.warn("Cannot instanciate: {}. Fall back to default: {}.", (Object)managerClass.getName(), (Object)FieldsManager.class.getName());
            instance = ReflectionUtil.newInstance(this.defaultImplClass);
            if (instance == null) {
                this.logger.error("Cannot instanciate: {}", (Object)this.defaultImplClass.getName());
            }
        }
        this.logger.debug("Installed {0}: {1}", (Object)this.clazz.getName(), instance);
        return (T)instance;
    }
}

