/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.util.RandomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBlobManager
implements BlobManager {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(SimpleBlobManager.class);
    protected File blobsDir;
    protected String metaFileNamePattern;
    protected String dataFileNamePattern;

    public SimpleBlobManager(File blobsDir, String metaFileNamePattern, String dataFileNamePattern) {
        this.blobsDir = blobsDir;
        if (!blobsDir.isDirectory() && !blobsDir.mkdirs()) {
            logger.warn("Invalid blobs directory: {}", (Object)blobsDir.getAbsolutePath());
        }
        this.metaFileNamePattern = metaFileNamePattern;
        this.dataFileNamePattern = dataFileNamePattern;
    }

    protected File getMetaFile(String code) {
        return RandomUtil.getCodeFile(this.blobsDir, this.metaFileNamePattern, code);
    }

    protected File getDataFile(String code) {
        return RandomUtil.getCodeFile(this.blobsDir, this.dataFileNamePattern, code);
    }

    public void ensureValidCode(String code) {
        if (!StringUtils.isAlphanumeric((String)code)) {
            throw new IllegalArgumentException("Code is not alphanumeric: " + code);
        }
    }

    @Override
    public void loadMetadata(Blob blob) throws IOException {
        this.ensureValidCode(blob.getCode());
        blob.setMetaProperties(this.loadMetaProperties(this.getMetaFile(blob.getCode())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadMetaProperties(File metaFile) throws IOException {
        Properties metaProperties = new Properties();
        FileInputStream metaStream = null;
        try {
            metaStream = new FileInputStream(metaFile);
            metaProperties.load(metaStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(metaStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)metaStream);
        return metaProperties;
    }

    @Override
    public InputStream openStream(Blob blob) throws IOException {
        this.ensureValidCode(blob.getCode());
        blob.setInputStream(new FileInputStream(this.getDataFile(blob.getCode())));
        return blob.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Blob blob) throws IOException {
        this.ensureValidCode(blob.getCode());
        File dataFile = this.getDataFile(blob.getCode());
        if (!dataFile.getParentFile().isDirectory()) {
            dataFile.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(dataFile);
        try {
            blob.setSize(IOUtils.copyLarge((InputStream)blob.getInputStream(), (OutputStream)out));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        File metaFile = this.getMetaFile(blob.getCode());
        if (!metaFile.getParentFile().isDirectory()) {
            metaFile.getParentFile().mkdirs();
        }
        out = new FileOutputStream(metaFile);
        try {
            blob.getMetaProperties().store(out, "Blob code #" + blob.getCode());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        blob.dispose();
    }

    @Override
    public boolean delete(Blob blob) {
        String code = blob.getCode();
        this.ensureValidCode(code);
        File metaFile = this.getMetaFile(code);
        File dataFile = this.getDataFile(code);
        boolean success = true;
        try {
            success = metaFile.delete() && success;
        }
        catch (Exception e) {
            logger.warn("Cound not delete meta file", (Throwable)e);
            success = false;
        }
        try {
            success = dataFile.delete() && success;
        }
        catch (Exception e) {
            logger.warn("Cound not delete data file", (Throwable)e);
            success = false;
        }
        return success;
    }

    public File getBlobsDir() {
        return this.blobsDir;
    }

    public void setBlobsDir(File blobsDir) {
        this.blobsDir = blobsDir;
    }

    public String getMetaFileNamePattern() {
        return this.metaFileNamePattern;
    }

    public void setMetaFileNamePattern(String metaFileNamePattern) {
        this.metaFileNamePattern = metaFileNamePattern;
    }

    public String getDataFileNamePattern() {
        return this.dataFileNamePattern;
    }

    public void setDataFileNamePattern(String dataFileNamePattern) {
        this.dataFileNamePattern = dataFileNamePattern;
    }
}

