/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.reflection.ReflectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.commons.lang.builder.ToStringBuilder;

public class JavaFieldAccessor
implements PropertyAccessor {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    private Field field;

    public JavaFieldAccessor(Field field) {
        assert (field != null);
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class getType() {
        return this.field.getType();
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot get property: %s", this.getName()), e);
        }
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(String.format("Cannot set property: %s", this.getName()), e);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.field.getDeclaredAnnotations();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.field.getName()).toString();
    }
}

