/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElementsProperties {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    public static final String PROPERTIES_RESOURCE = "elements.properties";
    public static final String CUSTOM_PROPERTIES_RESOURCE = "elements-custom.properties";
    public static final String FIELDS_MANAGER = "fields.manager";
    public static final String FIELDS_LIST = "fields.list";
    public static final String ANNOTATIONS_MANAGER = "annotations.manager";
    public static final String ANNOTATIONS_IMPLEMENTATION_LIST = "annotations.implementation.list";
    public static final String FIELDS_LABEL_CAPITALIZE = "fields.label.capitalize";
    public static final String FIELDS_DATE_FORMAT = "fields.date.format";
    public static final String FIELDS_DECIMAL_FORMAT = "elements.fields.format.decimal";
    private static final CompositeConfiguration configuration;
    public static final Logger logger;

    public static void addConfiguration(String resource) {
        try {
            configuration.addConfiguration((Configuration)new PropertiesConfiguration(resource));
        }
        catch (Exception e) {
            logger.warn(String.format("Error loading properties from: %s", resource), (Throwable)e);
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    private ElementsProperties() {
    }

    static {
        logger = LoggerFactory.getLogger(ElementsProperties.class);
        configuration = new CompositeConfiguration();
        ElementsProperties.addConfiguration(CUSTOM_PROPERTIES_RESOURCE);
        ElementsProperties.addConfiguration(PROPERTIES_RESOURCE);
    }
}

