/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements;

import com.manydesigns.elements.ElementsContext;
import com.manydesigns.elements.i18n.SimpleTextProvider;
import com.manydesigns.elements.i18n.TextProvider;
import com.manydesigns.elements.ognl.CustomTypeConverter;
import com.manydesigns.elements.ognl.DefaultMemberAccess;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ognl.DefaultTypeConverter;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.TypeConverter;

public final class ElementsThreadLocals {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    private static ThreadLocal<ElementsContext> threadLocalElementsContext = new ThreadLocal<ElementsContext>(){

        @Override
        protected ElementsContext initialValue() {
            return new ElementsContext();
        }
    };

    public static void destroy() {
        threadLocalElementsContext = null;
    }

    private ElementsThreadLocals() {
    }

    public static ElementsContext getElementsContext() {
        return threadLocalElementsContext.get();
    }

    public static TextProvider getTextProvider() {
        return ElementsThreadLocals.getElementsContext().getTextProvider();
    }

    public static void setTextProvider(TextProvider textProvider) {
        ElementsThreadLocals.getElementsContext().setTextProvider(textProvider);
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ElementsThreadLocals.getElementsContext().getHttpServletRequest();
    }

    public static void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        ElementsThreadLocals.getElementsContext().setHttpServletRequest(httpServletRequest);
    }

    public static HttpServletResponse getHttpServletResponse() {
        return ElementsThreadLocals.getElementsContext().getHttpServletResponse();
    }

    public static void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        ElementsThreadLocals.getElementsContext().setHttpServletResponse(httpServletResponse);
    }

    public static ServletContext getServletContext() {
        return ElementsThreadLocals.getElementsContext().getServletContext();
    }

    public static void setServletContext(ServletContext servletContext) {
        ElementsThreadLocals.getElementsContext().setServletContext(servletContext);
    }

    public static OgnlContext getOgnlContext() {
        return ElementsThreadLocals.getElementsContext().getOgnlContext();
    }

    public static void setOgnlContext(OgnlContext context) {
        ElementsThreadLocals.getElementsContext().setOgnlContext(context);
    }

    public static void setupDefaultElementsContext() {
        CustomTypeConverter typeConverter = new CustomTypeConverter((TypeConverter)new DefaultTypeConverter());
        OgnlContext ognlContext = (OgnlContext)Ognl.createDefaultContext(null, (MemberAccess)new DefaultMemberAccess(true), null, (TypeConverter)typeConverter);
        SimpleTextProvider textProvider = SimpleTextProvider.create();
        ElementsContext elementsContext = ElementsThreadLocals.getElementsContext();
        elementsContext.setOgnlContext(ognlContext);
        elementsContext.setTextProvider(textProvider);
        elementsContext.setHttpServletRequest(null);
        elementsContext.setHttpServletResponse(null);
        elementsContext.setServletContext(null);
    }

    public static void removeElementsContext() {
        threadLocalElementsContext.remove();
    }

    public static String getText(String key, Object ... args) {
        return ElementsThreadLocals.getTextProvider().getText(key, args);
    }
}

