/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.annotations.Searchable;
import com.manydesigns.elements.fields.helpers.FieldsManager;
import com.manydesigns.elements.fields.search.SearchField;
import com.manydesigns.elements.fields.search.SelectSearchField;
import com.manydesigns.elements.forms.AbstractFormBuilder;
import com.manydesigns.elements.forms.SearchForm;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchFormBuilder
extends AbstractFormBuilder {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    private static final Logger logger = LoggerFactory.getLogger(SearchFormBuilder.class);
    protected List<PropertyAccessor> propertyAccessors;

    public SearchFormBuilder(Class aClass) {
        this(JavaClassAccessor.getClassAccessor(aClass));
    }

    public SearchFormBuilder(ClassAccessor classAccessor) {
        super(classAccessor);
    }

    public SearchFormBuilder configFields(String ... fieldNames) {
        this.propertyAccessors = new ArrayList<PropertyAccessor>();
        for (String current : fieldNames) {
            try {
                PropertyAccessor accessor = this.classAccessor.getProperty(current);
                this.propertyAccessors.add(accessor);
            }
            catch (NoSuchFieldException e) {
                logger.warn("Field not found: " + current, (Throwable)e);
            }
        }
        return this;
    }

    public SearchFormBuilder configPrefix(String prefix) {
        logger.debug("prefix = {}", (Object)prefix);
        this.prefix = prefix;
        return this;
    }

    public SearchFormBuilder configSelectionProvider(SelectionProvider selectionProvider, String ... fieldNames) {
        this.selectionProviders.put(fieldNames, selectionProvider);
        return this;
    }

    public SearchFormBuilder configReflectiveFields() {
        logger.debug("configReflectiveFields");
        this.propertyAccessors = new ArrayList<PropertyAccessor>();
        for (PropertyAccessor current : this.classAccessor.getProperties()) {
            if (!this.isPropertyEnabled(current)) continue;
            Searchable searchableAnnotation = current.getAnnotation(Searchable.class);
            if (searchableAnnotation != null && !searchableAnnotation.value()) {
                logger.debug("Skipping non-searchable field: {}", (Object)current.getName());
                continue;
            }
            this.propertyAccessors.add(current);
        }
        return this;
    }

    public SearchForm build() {
        logger.debug("build");
        SearchForm searchForm = new SearchForm();
        FieldsManager manager = FieldsManager.getManager();
        if (this.propertyAccessors == null) {
            this.configReflectiveFields();
        }
        HashMap<String, SearchField> fieldMap = new HashMap<String, SearchField>();
        for (PropertyAccessor propertyAccessor : this.propertyAccessors) {
            SearchField field = null;
            String fieldName = propertyAccessor.getName();
            for (Map.Entry current : this.selectionProviders.entrySet()) {
                Object[] fieldNames = (String[])current.getKey();
                int index = ArrayUtils.indexOf((Object[])fieldNames, (Object)fieldName);
                if (index < 0) continue;
                field = new SelectSearchField(propertyAccessor, (SelectionProvider)current.getValue(), this.prefix);
                break;
            }
            if (field == null) {
                field = manager.tryToInstantiateSearchField(this.classAccessor, propertyAccessor, this.prefix);
            }
            if (field == null) {
                logger.warn("Cannot instantiate field for property {}", (Object)propertyAccessor);
                continue;
            }
            fieldMap.put(fieldName, field);
            searchForm.add(field);
        }
        for (Map.Entry entry : this.selectionProviders.entrySet()) {
            String[] fieldNames = (String[])entry.getKey();
            SelectionProvider selectionProvider = (SelectionProvider)entry.getValue();
            SelectionModel selectionModel = selectionProvider.createSelectionModel();
            SelectSearchField previousField = null;
            for (int i = 0; i < fieldNames.length; ++i) {
                SelectSearchField selectSearchField = (SelectSearchField)fieldMap.get(fieldNames[i]);
                if (selectSearchField == null) {
                    previousField = null;
                    continue;
                }
                selectSearchField.setSelectionModel(selectionModel);
                selectSearchField.setSelectionModelIndex(i);
                if (previousField != null) {
                    selectSearchField.setPreviousSelectField(previousField);
                    previousField.setNextSelectField(selectSearchField);
                }
                previousField = selectSearchField;
            }
        }
        return searchForm;
    }
}

