/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.KeyValueAccessor;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.DateFormat;
import com.manydesigns.elements.fields.AbstractTextField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractDateField<T>
extends AbstractTextField<T> {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected final String datePattern;
    protected DateTimeFormatter dateTimeFormatter;
    protected final boolean containsTime;
    protected T dateValue;
    protected boolean dateFormatError;

    public AbstractDateField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public AbstractDateField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        DateFormat dateFormatAnnotation = accessor.getAnnotation(DateFormat.class);
        if (dateFormatAnnotation != null) {
            this.datePattern = dateFormatAnnotation.value();
        } else {
            Configuration elementsConfiguration = ElementsProperties.getConfiguration();
            this.datePattern = elementsConfiguration.getString("fields.date.format");
        }
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.datePattern);
        this.setSize(this.dateTimeFormatter.getParser().estimateParsedLength());
        this.containsTime = this.datePattern.contains("HH") || this.datePattern.contains("mm") || this.datePattern.contains("ss");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String reqValue = req.getParameter(this.inputName);
        if (reqValue == null) {
            return;
        }
        this.setStringValue(reqValue.trim());
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (this.dateFormatError) {
            this.errors.add(this.getText("elements.error.field.date.format", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        Object value;
        super.readFromObject(obj);
        this.dateValue = obj == null ? null : ((value = this.accessor.get(obj)) == null ? null : value);
        this.updateStringValue();
    }

    protected void updateStringValue() {
        if (this.dateValue == null) {
            this.stringValue = null;
        } else {
            DateTime dateTime = this.fromDate(this.dateValue);
            this.stringValue = this.dateTimeFormatter.print((ReadableInstant)dateTime);
        }
    }

    @Override
    public void writeToObject(Object obj) {
        this.writeToObject(obj, this.dateValue);
    }

    @Override
    public void valueToXhtmlEdit(XhtmlBuffer xb) {
        xb.writeInputText(this.id, this.inputName, this.stringValue, this.labelPlaceholder ? this.label : null, "form-control", this.size, this.maxLength);
        xb.openElement("span");
        xb.addAttribute("class", "help-block");
        xb.write("(");
        xb.write(this.datePattern);
        xb.write(") ");
        xb.closeElement("span");
        String js = MessageFormat.format("$(function() '{' setupDatePicker(''#{0}'', ''{1}''); '}');", StringEscapeUtils.escapeJavaScript((String)this.id), StringEscapeUtils.escapeJavaScript((String)this.datePattern));
        xb.writeJavaScript(js);
        if (this.mode.isBulk()) {
            xb.writeJavaScript("$(function() { configureBulkEditDateField('" + this.id + "', '" + this.bulkCheckboxName + "'); " + "});");
        }
    }

    @Override
    public void setStringValue(String stringValue) {
        super.setStringValue(stringValue);
        this.dateFormatError = false;
        this.dateValue = null;
        if (stringValue.length() == 0) {
            return;
        }
        try {
            DateTime dateTime = Util.parseDateTime(this.dateTimeFormatter, stringValue, this.containsTime);
            this.dateValue = this.toDate(dateTime);
        }
        catch (Throwable e) {
            this.dateFormatError = true;
            logger.debug("Cannot parse date: {}", (Object)stringValue);
        }
    }

    @Override
    protected T maybeConvertValue(Object value) {
        if (value instanceof Number) {
            return this.toDate((Number)value);
        }
        return super.maybeConvertValue(value);
    }

    @Override
    public void readFrom(KeyValueAccessor keyValueAccessor) {
        super.readFrom(keyValueAccessor);
        this.updateStringValue();
    }

    protected abstract T toDate(@NotNull Number var1);

    protected abstract T toDate(@NotNull DateTime var1);

    protected abstract DateTime fromDate(@NotNull T var1);

    @Override
    public T getValue() {
        return this.dateValue;
    }

    @Override
    public void setValue(T dateValue) {
        this.dateValue = dateValue;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }
}

