/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.composites;

import com.manydesigns.elements.Element;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCompositeElement<T extends Element>
extends ArrayList<T>
implements Element {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected String id;

    public AbstractCompositeElement(int initialCapacity) {
        super(initialCapacity);
    }

    public AbstractCompositeElement() {
    }

    public AbstractCompositeElement(Collection<? extends T> c) {
        super(c);
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        for (Element current : this) {
            current.readFromRequest(req);
        }
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (Element current : this) {
            result = current.validate() && result;
        }
        return result;
    }

    @Override
    public void readFromObject(Object obj) {
        for (Element current : this) {
            current.readFromObject(obj);
        }
    }

    @Override
    public void writeToObject(Object obj) {
        for (Element current : this) {
            current.writeToObject(obj);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Field findFieldByPropertyName(String propertyName) {
        for (Element element : this) {
            Field field;
            PropertyAccessor accessor;
            if (!(element instanceof Field ? (accessor = (field = (Field)element).getPropertyAccessor()).getName().equals(propertyName) : element instanceof AbstractCompositeElement && (field = ((AbstractCompositeElement)element).findFieldByPropertyName(propertyName)) != null)) continue;
            return field;
        }
        return null;
    }

    public Collection<Field> fields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Element element : this) {
            if (element instanceof Field) {
                Field field = (Field)element;
                fields.add(field);
                continue;
            }
            if (!(element instanceof AbstractCompositeElement)) continue;
            fields.addAll(((AbstractCompositeElement)element).fields());
        }
        return fields;
    }
}

