/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.helpers;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.helpers.FieldHelper;
import com.manydesigns.elements.fields.search.SearchField;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.InstanceBuilder;
import com.manydesigns.elements.util.ReflectionUtil;
import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsManager
implements FieldHelper {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected static final Configuration elementsConfiguration;
    protected static final FieldsManager manager;
    public static final Logger logger;
    protected final ArrayList<FieldHelper> helperList = new ArrayList();

    public static FieldsManager getManager() {
        return manager;
    }

    public FieldsManager() {
        String[] fields = elementsConfiguration.getStringArray("fields.list");
        if (fields == null) {
            logger.debug("Empty list");
            return;
        }
        for (String current : fields) {
            this.addFieldHelper(current);
        }
    }

    public void addFieldHelper(String fieldHelperClassName) {
        String helperClassName = fieldHelperClassName.trim();
        logger.debug("Adding field helper: {}", (Object)helperClassName);
        FieldHelper helper = (FieldHelper)ReflectionUtil.newInstance(helperClassName);
        if (helper == null) {
            logger.debug("Failed to add field helper: {}", (Object)helperClassName);
        } else {
            this.helperList.add(helper);
            logger.debug("Added field helper: {}", (Object)helper);
        }
    }

    @Override
    public Field tryToInstantiateField(ClassAccessor classAccessor, PropertyAccessor propertyAccessor, Mode mode, String prefix) {
        for (FieldHelper current : this.helperList) {
            Field result = current.tryToInstantiateField(classAccessor, propertyAccessor, mode, prefix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public SearchField tryToInstantiateSearchField(ClassAccessor classAccessor, PropertyAccessor propertyAccessor, String prefix) {
        for (FieldHelper current : this.helperList) {
            SearchField result = current.tryToInstantiateSearchField(classAccessor, propertyAccessor, prefix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ArrayList<FieldHelper> getHelperList() {
        return this.helperList;
    }

    static {
        logger = LoggerFactory.getLogger(FieldsManager.class);
        elementsConfiguration = ElementsProperties.getConfiguration();
        String managerClassName = elementsConfiguration.getString("fields.manager");
        InstanceBuilder<FieldsManager> builder = new InstanceBuilder<FieldsManager>(FieldsManager.class, FieldsManager.class, logger);
        manager = builder.createInstance(managerClassName);
    }
}

