/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.DecimalFormat;
import com.manydesigns.elements.annotations.MaxDecimalValue;
import com.manydesigns.elements.annotations.MaxIntValue;
import com.manydesigns.elements.annotations.Memory;
import com.manydesigns.elements.annotations.MinDecimalValue;
import com.manydesigns.elements.annotations.MinIntValue;
import com.manydesigns.elements.annotations.PrecisionScale;
import com.manydesigns.elements.fields.AbstractTextField;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import javax.servlet.http.HttpServletRequest;

public class NumericField
extends AbstractTextField {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected BigDecimal decimalValue;
    protected java.text.DecimalFormat decimalFormat;
    protected int precision;
    protected int scale;
    protected BigDecimal minValue;
    protected BigDecimal maxValue;
    protected boolean decimalFormatError;

    public NumericField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        DecimalFormat decimalFormatAnnotation;
        Class type = accessor.getType();
        if (type == Byte.class || type == Byte.TYPE) {
            this.minValue = new BigDecimal(-128);
            this.maxValue = new BigDecimal(127);
        } else if (type == Short.class || type == Short.TYPE) {
            this.minValue = new BigDecimal(Short.MIN_VALUE);
            this.maxValue = new BigDecimal(Short.MAX_VALUE);
        } else if (type == Integer.class || type == Integer.TYPE) {
            this.minValue = new BigDecimal(Integer.MIN_VALUE);
            this.maxValue = new BigDecimal(Integer.MAX_VALUE);
        } else if (type == Long.class || type == Long.TYPE) {
            this.minValue = new BigDecimal(Long.MIN_VALUE);
            this.maxValue = new BigDecimal(Long.MAX_VALUE);
        }
        if (type.isPrimitive()) {
            this.setRequired(true);
        }
        if (accessor.isAnnotationPresent(PrecisionScale.class)) {
            BigDecimal absMaxValue;
            PrecisionScale annotation = accessor.getAnnotation(PrecisionScale.class);
            this.precision = annotation.precision();
            this.scale = annotation.scale();
            BigInteger unscaledMaxValue = BigInteger.TEN.pow(this.precision).subtract(BigInteger.ONE);
            this.maxValue = absMaxValue = new BigDecimal(unscaledMaxValue, this.scale);
            this.minValue = absMaxValue.negate();
        }
        if (accessor.isAnnotationPresent(MinDecimalValue.class)) {
            double minDecimalValue = accessor.getAnnotation(MinDecimalValue.class).value();
            this.minValue = new BigDecimal(minDecimalValue);
        } else if (accessor.isAnnotationPresent(MinIntValue.class)) {
            int minIntValue = accessor.getAnnotation(MinIntValue.class).value();
            this.minValue = new BigDecimal(minIntValue);
        }
        if (accessor.isAnnotationPresent(MaxDecimalValue.class)) {
            double maxDecimalValue = accessor.getAnnotation(MaxDecimalValue.class).value();
            this.maxValue = new BigDecimal(maxDecimalValue);
        } else if (accessor.isAnnotationPresent(MaxIntValue.class)) {
            int maxIntValue = accessor.getAnnotation(MaxIntValue.class).value();
            this.maxValue = new BigDecimal(maxIntValue);
        }
        if (accessor.isAnnotationPresent(Memory.class)) {
            this.decimalFormat = new java.text.DecimalFormat("#,##0");
        }
        if ((decimalFormatAnnotation = accessor.getAnnotation(DecimalFormat.class)) != null) {
            this.decimalFormat = new java.text.DecimalFormat(decimalFormatAnnotation.value());
        }
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        BigDecimal tmpValue;
        block6: {
            super.readFromRequest(req);
            if (this.mode.isView(this.insertable, this.updatable)) {
                return;
            }
            String reqValue = req.getParameter(this.inputName);
            if (reqValue == null) {
                return;
            }
            this.stringValue = reqValue.trim();
            this.decimalValue = null;
            this.decimalFormatError = false;
            if (this.stringValue.length() == 0) {
                return;
            }
            try {
                tmpValue = (BigDecimal)OgnlUtils.convertValue(this.stringValue, BigDecimal.class);
            }
            catch (Throwable e) {
                if (this.decimalFormat == null) {
                    this.decimalFormatError = true;
                    return;
                }
                this.decimalFormat.setParseBigDecimal(true);
                ParsePosition parsePos = new ParsePosition(0);
                tmpValue = (BigDecimal)this.decimalFormat.parse(this.stringValue, parsePos);
                if (this.stringValue.length() == parsePos.getIndex()) break block6;
                this.decimalFormatError = true;
                return;
            }
        }
        this.decimalValue = tmpValue.setScale(this.scale, 6);
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (this.stringValue == null || this.stringValue.length() == 0) {
            return true;
        }
        if (this.decimalFormatError) {
            this.errors.add(this.getText("elements.error.field.decimal.format", new Object[0]));
            return false;
        }
        if (this.minValue != null && this.decimalValue.compareTo(this.minValue) < 0) {
            this.errors.add(this.getText("elements.error.field.greater.or.equal", this.minValue));
            return false;
        }
        if (this.maxValue != null && this.decimalValue.compareTo(this.maxValue) > 0) {
            this.errors.add(this.getText("elements.error.field.less.or.equal", this.maxValue));
            return false;
        }
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        if (obj == null) {
            this.decimalValue = null;
        } else {
            Object value = this.accessor.get(obj);
            this.decimalValue = (BigDecimal)OgnlUtils.convertValue(value, BigDecimal.class);
        }
        this.stringValue = this.decimalValue == null ? null : (this.decimalFormat == null ? OgnlUtils.convertValueToString(this.decimalValue) : this.decimalFormat.format(this.decimalValue));
    }

    @Override
    public void writeToObject(Object obj) {
        Class type = this.accessor.getType();
        Object value = OgnlUtils.convertValue(this.decimalValue, type);
        this.writeToObject(obj, value);
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue == null ? null : new BigDecimal(maxValue);
    }

    public java.text.DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(java.text.DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public BigDecimal getValue() {
        return this.decimalValue;
    }

    public void setValue(BigDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

