/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.DateFormat;
import com.manydesigns.elements.fields.AbstractTextField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.text.MessageFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateField
extends AbstractTextField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected final String datePattern;
    protected DateTimeFormatter dateTimeFormatter;
    protected final boolean containsTime;
    protected final String jsDatePattern;
    protected Date dateValue;
    protected boolean dateFormatError;

    public DateField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public DateField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        DateFormat dateFormatAnnotation = accessor.getAnnotation(DateFormat.class);
        if (dateFormatAnnotation != null) {
            this.datePattern = dateFormatAnnotation.value();
        } else {
            Configuration elementsConfiguration = ElementsProperties.getConfiguration();
            this.datePattern = elementsConfiguration.getString("fields.date.format");
        }
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.datePattern);
        this.setSize(this.dateTimeFormatter.getParser().estimateParsedLength());
        this.containsTime = this.datePattern.contains("HH") || this.datePattern.contains("mm") || this.datePattern.contains("ss");
        String tmpPattern = this.datePattern;
        if (tmpPattern.contains("MM")) {
            tmpPattern = tmpPattern.replaceAll("MM", "mm");
        }
        this.jsDatePattern = tmpPattern;
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String reqValue = req.getParameter(this.inputName);
        if (reqValue == null) {
            return;
        }
        this.stringValue = reqValue.trim();
        this.dateFormatError = false;
        this.dateValue = null;
        if (this.stringValue.length() == 0) {
            return;
        }
        try {
            this.dateValue = Util.parseDateTime(this.dateTimeFormatter, this.stringValue, this.containsTime);
        }
        catch (Throwable e) {
            this.dateFormatError = true;
            logger.debug("Cannot parse date: {}", (Object)this.stringValue);
        }
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (this.dateFormatError) {
            this.errors.add(this.getText("elements.error.field.date.format", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        Object value;
        super.readFromObject(obj);
        this.dateValue = obj == null ? null : ((value = this.accessor.get(obj)) == null ? null : (Date)value);
        if (this.dateValue == null) {
            this.stringValue = null;
        } else {
            DateTime dateTime = new DateTime((Object)this.dateValue);
            this.stringValue = this.dateTimeFormatter.print((ReadableInstant)dateTime);
        }
    }

    @Override
    public void writeToObject(Object obj) {
        this.writeToObject(obj, this.dateValue);
    }

    @Override
    public void valueToXhtmlEdit(XhtmlBuffer xb) {
        xb.writeInputText(this.id, this.inputName, this.stringValue, this.labelPlaceholder ? this.label : null, "form-control", this.size, this.maxLength);
        xb.openElement("span");
        xb.addAttribute("class", "help-block");
        xb.write("(");
        xb.write(this.datePattern);
        xb.write(") ");
        xb.closeElement("span");
        if (!this.containsTime) {
            String js = MessageFormat.format("setupDatePicker(''#{0}'', ''{1}'');", StringEscapeUtils.escapeJavaScript((String)this.id), StringEscapeUtils.escapeJavaScript((String)this.jsDatePattern));
            xb.writeJavaScript(js);
        }
        if (this.mode.isBulk()) {
            xb.writeJavaScript("$(function() { configureBulkEditDateField('" + this.id + "', '" + this.bulkCheckboxName + "'); " + "});");
        }
    }

    @Override
    public Date getValue() {
        return this.dateValue;
    }

    public void setValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }
}

