/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Device;
import com.mailosaur.models.DeviceCreateOptions;
import com.mailosaur.models.DeviceListResult;
import com.mailosaur.models.OtpResult;
import java.io.IOException;

public class Devices {
    private MailosaurClient client;

    public Devices(MailosaurClient client) {
        this.client = client;
    }

    public DeviceListResult list() throws IOException, MailosaurException {
        return (DeviceListResult)this.client.request("GET", "api/devices").parseAs(DeviceListResult.class);
    }

    public Device create(DeviceCreateOptions options) throws IOException, MailosaurException {
        return (Device)this.client.request("POST", "api/devices", options).parseAs(Device.class);
    }

    public OtpResult otp(String query) throws IOException, MailosaurException {
        if (query.contains("-")) {
            return (OtpResult)this.client.request("GET", "api/devices/" + query + "/otp").parseAs(OtpResult.class);
        }
        DeviceCreateOptions options = new DeviceCreateOptions().withSharedSecret(query);
        return (OtpResult)this.client.request("POST", "api/devices/otp", options).parseAs(OtpResult.class);
    }

    public void delete(String deviceId) throws MailosaurException {
        this.client.request("DELETE", "api/devices/" + deviceId);
    }
}

