/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.HttpResponse;
import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Message;
import com.mailosaur.models.MessageCreateOptions;
import com.mailosaur.models.MessageForwardOptions;
import com.mailosaur.models.MessageListParams;
import com.mailosaur.models.MessageListResult;
import com.mailosaur.models.MessageReplyOptions;
import com.mailosaur.models.MessageSearchParams;
import com.mailosaur.models.SearchCriteria;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class Messages {
    private final MailosaurClient client;

    public Messages(MailosaurClient client) {
        this.client = client;
    }

    public Message get(MessageSearchParams params, SearchCriteria criteria) throws IOException, MailosaurException {
        if (params.timeout() == null) {
            params.withTimeout(10000);
        }
        if (params.receivedAfter() == null) {
            params.withReceivedAfter(new Date(System.currentTimeMillis() - 3600000L));
        }
        if (params.server().length() != 8) {
            throw new MailosaurException("Must provide a valid Server ID.", "invalid_request");
        }
        MessageListResult result = this.search(params, criteria);
        return this.getById(result.items().get(0).id());
    }

    @Deprecated
    public Message get(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server);
        return this.get(params, criteria);
    }

    @Deprecated
    public Message get(String server, SearchCriteria criteria, int timeout) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withTimeout(timeout);
        return this.get(params, criteria);
    }

    @Deprecated
    public Message get(String server, SearchCriteria criteria, Date receivedAfter) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withReceivedAfter(receivedAfter);
        return this.get(params, criteria);
    }

    @Deprecated
    public Message get(String server, SearchCriteria criteria, Integer timeout, Date receivedAfter) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withTimeout(timeout).withReceivedAfter(receivedAfter);
        return this.get(params, criteria);
    }

    public Message getById(String id) throws MailosaurException, IOException {
        return (Message)this.client.request("GET", "api/messages/" + id).parseAs(Message.class);
    }

    public void delete(String id) throws MailosaurException {
        this.client.request("DELETE", "api/messages/" + id);
    }

    public void deleteAll(String server) throws MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        this.client.request("DELETE", "api/messages", query);
    }

    public MessageListResult list(MessageListParams params) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", params.server());
        if (params.page() != null) {
            query.put("page", params.page().toString());
        }
        if (params.itemsPerPage() != null) {
            query.put("itemsPerPage", params.itemsPerPage().toString());
        }
        if (params.receivedAfter() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            query.put("receivedAfter", dateFormat.format(params.receivedAfter()));
        }
        if (params.dir() != null) {
            query.put("dir", params.dir());
        }
        return (MessageListResult)this.client.request("GET", "api/messages", query).parseAs(MessageListResult.class);
    }

    @Deprecated
    public MessageListResult list(String server) throws IOException, MailosaurException {
        MessageListParams params = new MessageListParams();
        params.withServer(server);
        return this.list(params);
    }

    @Deprecated
    public MessageListResult list(String server, Date receivedAfter) throws IOException, MailosaurException {
        MessageListParams params = new MessageListParams();
        params.withServer(server).withReceivedAfter(receivedAfter);
        return this.list(params);
    }

    @Deprecated
    public MessageListResult list(String server, int page, int itemsPerPage) throws IOException, MailosaurException {
        MessageListParams params = new MessageListParams();
        params.withServer(server).withPage(page).withItemsPerPage(itemsPerPage);
        return this.list(params);
    }

    @Deprecated
    public MessageListResult list(String server, Integer page, Integer itemsPerPage, Date receivedAfter) throws IOException, MailosaurException {
        MessageListParams params = new MessageListParams();
        params.withServer(server).withPage(page).withItemsPerPage(itemsPerPage).withReceivedAfter(receivedAfter);
        return this.list(params);
    }

    public MessageListResult search(MessageSearchParams params, SearchCriteria criteria) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", params.server());
        if (params.page() != null) {
            query.put("page", params.page().toString());
        }
        if (params.itemsPerPage() != null) {
            query.put("itemsPerPage", params.itemsPerPage().toString());
        }
        if (params.receivedAfter() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            query.put("receivedAfter", dateFormat.format(params.receivedAfter()));
        }
        if (params.dir() != null) {
            query.put("dir", params.dir());
        }
        if (params.errorOnTimeout() == null) {
            params.withErrorOnTimeout(true);
        }
        int pollCount = 0;
        long startTime = new Date().getTime();
        while (true) {
            HttpResponse response = this.client.request("POST", "api/messages/search", criteria, query);
            MessageListResult result = (MessageListResult)response.parseAs(MessageListResult.class);
            if (params.timeout() == null || params.timeout() == 0 || result.items().size() != 0) {
                return result;
            }
            List headerValues = response.getHeaders().getHeaderStringValues("x-ms-delay");
            String[] delayStrings = (headerValues.size() == 0 ? "1000" : (String)headerValues.get(0)).split(",");
            int[] delayPattern = new int[delayStrings.length];
            for (int i = 0; i < delayStrings.length; ++i) {
                delayPattern[i] = Integer.parseInt(delayStrings[i].trim());
            }
            int delay = pollCount >= delayPattern.length ? delayPattern[delayPattern.length - 1] : delayPattern[pollCount];
            ++pollCount;
            if (new Date().getTime() - startTime + (long)delay > (long)params.timeout().intValue()) {
                if (!params.errorOnTimeout().booleanValue()) {
                    return result;
                }
                throw new MailosaurException("No matching messages found in time. By default, only messages received in the last hour are checked (use receivedAfter to override this).", "search_timeout");
            }
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withErrorOnTimeout(true);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, int page, int itemsPerPage) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withPage(page).withItemsPerPage(itemsPerPage).withErrorOnTimeout(true);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, int timeout) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withTimeout(timeout).withErrorOnTimeout(true);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, int timeout, boolean errorOnTimeout) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withItemsPerPage(timeout).withErrorOnTimeout(errorOnTimeout);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, Date receivedAfter) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withReceivedAfter(receivedAfter).withErrorOnTimeout(true);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, int timeout, Date receivedAfter) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withTimeout(timeout).withReceivedAfter(receivedAfter).withErrorOnTimeout(true);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, int timeout, boolean errorOnTimeout, Date receivedAfter) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withTimeout(timeout).withReceivedAfter(receivedAfter).withErrorOnTimeout(errorOnTimeout);
        return this.search(params, criteria);
    }

    @Deprecated
    public MessageListResult search(String server, SearchCriteria criteria, Integer page, Integer itemsPerPage, Integer timeout, Date receivedAfter, boolean errorOnTimeout) throws IOException, MailosaurException {
        MessageSearchParams params = new MessageSearchParams();
        params.withServer(server).withPage(page).withItemsPerPage(itemsPerPage).withTimeout(timeout).withReceivedAfter(receivedAfter).withErrorOnTimeout(errorOnTimeout);
        return this.search(params, criteria);
    }

    public Message create(String server, MessageCreateOptions messageCreateOptions) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        return (Message)this.client.request("POST", "api/messages", messageCreateOptions, query).parseAs(Message.class);
    }

    public Message forward(String id, MessageForwardOptions messageForwardOptions) throws IOException, MailosaurException {
        return (Message)this.client.request("POST", "api/messages/" + id + "/forward", messageForwardOptions).parseAs(Message.class);
    }

    public Message reply(String id, MessageReplyOptions messageReplyOptions) throws IOException, MailosaurException {
        return (Message)this.client.request("POST", "api/messages/" + id + "/reply", messageReplyOptions).parseAs(Message.class);
    }
}

