/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.HttpResponse;
import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Message;
import com.mailosaur.models.MessageListResult;
import com.mailosaur.models.SearchCriteria;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class Messages {
    private final MailosaurClient client;

    public Messages(MailosaurClient client) {
        this.client = client;
    }

    public Message get(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        return this.get(server, criteria, null, null);
    }

    public Message get(String server, SearchCriteria criteria, int timeout) throws IOException, MailosaurException {
        return this.get(server, criteria, timeout, null);
    }

    public Message get(String server, SearchCriteria criteria, Date receivedAfter) throws IOException, MailosaurException {
        return this.get(server, criteria, null, receivedAfter);
    }

    public Message get(String server, SearchCriteria criteria, Integer timeout, Date receivedAfter) throws IOException, MailosaurException {
        timeout = timeout != null ? timeout : 10000;
        Date date = receivedAfter = receivedAfter != null ? receivedAfter : new Date(System.currentTimeMillis() - 3600000L);
        if (server.length() != 8) {
            throw new MailosaurException("Must provide a valid Server ID.", "invalid_request");
        }
        MessageListResult result = this.search(server, criteria, 0, 1, timeout, receivedAfter, true);
        return this.getById(result.items().get(0).id());
    }

    public Message getById(String id) throws MailosaurException, IOException {
        return (Message)this.client.request("GET", "api/messages/" + id).parseAs(Message.class);
    }

    public void delete(String id) throws MailosaurException {
        this.client.request("DELETE", "api/messages/" + id);
    }

    public void deleteAll(String server) throws MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        this.client.request("DELETE", "api/messages", query);
    }

    public MessageListResult list(String server) throws IOException, MailosaurException {
        return this.list(server, null, null, null);
    }

    public MessageListResult list(String server, Date receivedAfter) throws IOException, MailosaurException {
        return this.list(server, null, null, receivedAfter);
    }

    public MessageListResult list(String server, int page, int itemsPerPage) throws IOException, MailosaurException {
        return this.list(server, page, itemsPerPage, null);
    }

    public MessageListResult list(String server, Integer page, Integer itemsPerPage, Date receivedAfter) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        if (page != null) {
            query.put("page", page.toString());
        }
        if (itemsPerPage != null) {
            query.put("itemsPerPage", itemsPerPage.toString());
        }
        if (receivedAfter != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            query.put("receivedAfter", dateFormat.format(receivedAfter));
        }
        return (MessageListResult)this.client.request("GET", "api/messages", query).parseAs(MessageListResult.class);
    }

    public MessageListResult search(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, null, null, true);
    }

    public MessageListResult search(String server, SearchCriteria criteria, int page, int itemsPerPage) throws IOException, MailosaurException {
        return this.search(server, criteria, page, itemsPerPage, null, null, true);
    }

    public MessageListResult search(String server, SearchCriteria criteria, int timeout) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, timeout, null, true);
    }

    public MessageListResult search(String server, SearchCriteria criteria, int timeout, boolean errorOnTimeout) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, timeout, null, errorOnTimeout);
    }

    public MessageListResult search(String server, SearchCriteria criteria, Date receivedAfter) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, null, receivedAfter, true);
    }

    public MessageListResult search(String server, SearchCriteria criteria, int timeout, Date receivedAfter) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, timeout, receivedAfter, true);
    }

    public MessageListResult search(String server, SearchCriteria criteria, int timeout, boolean errorOnTimeout, Date receivedAfter) throws IOException, MailosaurException {
        return this.search(server, criteria, null, null, timeout, receivedAfter, errorOnTimeout);
    }

    public MessageListResult search(String server, SearchCriteria criteria, Integer page, Integer itemsPerPage, Integer timeout, Date receivedAfter, boolean errorOnTimeout) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        if (page != null) {
            query.put("page", page.toString());
        }
        if (itemsPerPage != null) {
            query.put("itemsPerPage", itemsPerPage.toString());
        }
        if (receivedAfter != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            query.put("receivedAfter", dateFormat.format(receivedAfter));
        }
        int pollCount = 0;
        long startTime = new Date().getTime();
        while (true) {
            HttpResponse response = this.client.request("POST", "api/messages/search", criteria, query);
            MessageListResult result = (MessageListResult)response.parseAs(MessageListResult.class);
            if (timeout == null || timeout == 0 || result.items().size() != 0) {
                return result;
            }
            List headerValues = response.getHeaders().getHeaderStringValues("x-ms-delay");
            String[] delayStrings = (headerValues.size() == 0 ? "1000" : (String)headerValues.get(0)).split(",");
            int[] delayPattern = new int[delayStrings.length];
            for (int i = 0; i < delayStrings.length; ++i) {
                delayPattern[i] = Integer.parseInt(delayStrings[i].trim());
            }
            int delay = pollCount >= delayPattern.length ? delayPattern[delayPattern.length - 1] : delayPattern[pollCount];
            ++pollCount;
            if (new Date().getTime() - startTime + (long)delay > (long)timeout.intValue()) {
                if (!errorOnTimeout) {
                    return result;
                }
                throw new MailosaurException("No matching messages found in time. By default, only messages received in the last hour are checked (use receivedAfter to override this).", "search_timeout");
            }
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

