/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.mailosaur.MailosaurClient;
import com.mailosaur.MailosaurException;
import com.mailosaur.models.Message;
import com.mailosaur.models.MessageListResult;
import com.mailosaur.models.SearchCriteria;
import java.io.IOException;
import java.util.HashMap;

public class Messages {
    private MailosaurClient client;

    public Messages(MailosaurClient client) {
        this.client = client;
    }

    public Message get(String id) throws IOException, MailosaurException {
        return (Message)this.client.request("GET", "api/messages/" + id).parseAs(Message.class);
    }

    public void delete(String id) throws MailosaurException {
        this.client.request("DELETE", "api/messages/" + id);
    }

    public void deleteAll(String server) throws MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        this.client.request("DELETE", "api/messages", query);
    }

    public MessageListResult list(String server) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        return (MessageListResult)this.client.request("GET", "api/messages", query).parseAs(MessageListResult.class);
    }

    public MessageListResult search(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        return (MessageListResult)this.client.request("POST", "api/messages/search", criteria, query).parseAs(MessageListResult.class);
    }

    public Message waitFor(String server, SearchCriteria criteria) throws IOException, MailosaurException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("server", server);
        return (Message)this.client.request("POST", "api/messages/await", criteria, query).parseAs(Message.class);
    }
}

