/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.CookieStore;
import com.machinepublishers.jbrowserdriver.ImeHandlerServer;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.OptionsRemote;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.TimeoutsServer;
import com.machinepublishers.jbrowserdriver.WindowServer;
import com.sun.webkit.network.CookieManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

class OptionsServer
extends RemoteObject
implements OptionsRemote,
WebDriver.Options {
    private static final CookieStore cookieStore = (CookieStore)CookieManager.getDefault();
    private final Context context;
    private final ImeHandlerServer imeHandler = new ImeHandlerServer();
    private final AtomicReference<TimeoutsServer> timeouts;
    private static final Pattern domain = Pattern.compile(".*?://(?:[^/]*@)?\\[?([^\\]:/]*).*");

    OptionsServer(Context context, AtomicReference<TimeoutsServer> timeouts) throws RemoteException {
        this.context = context;
        this.timeouts = timeouts;
    }

    private org.apache.http.cookie.Cookie convert(Cookie in) {
        String domainStr;
        BasicClientCookie out;
        block4: {
            out = new BasicClientCookie(in.getName(), in.getValue());
            domainStr = null;
            if (StringUtils.isEmpty((String)in.getDomain())) {
                String urlStr = this.context.item().engine.get().getLocation();
                try {
                    URL url = new URL(urlStr);
                    domainStr = url.getHost();
                }
                catch (MalformedURLException e) {
                    Matcher matcher = domain.matcher(urlStr);
                    if (!matcher.matches()) break block4;
                    domainStr = matcher.group(1);
                }
            }
        }
        out.setDomain(domainStr == null ? in.getDomain() : domainStr);
        if (in.getExpiry() != null) {
            out.setExpiryDate(in.getExpiry());
        }
        out.setPath(in.getPath());
        out.setSecure(in.isSecure());
        out.setValue(in.getValue());
        out.setVersion(1);
        return out;
    }

    private static Cookie convert(org.apache.http.cookie.Cookie in) {
        return new Cookie(in.getName(), in.getValue(), in.getDomain(), in.getPath(), in.getExpiryDate(), in.isSecure());
    }

    @Override
    public void addCookie(Cookie cookie) {
        cookieStore.addCookie(this.convert(cookie));
    }

    @Override
    public void deleteAllCookies() {
        cookieStore.clear();
    }

    @Override
    public void deleteCookie(Cookie cookie) {
        List<org.apache.http.cookie.Cookie> cookies = cookieStore.getCookies();
        String toDelete = cookie.getDomain().toLowerCase() + "\n" + cookie.getName().toLowerCase() + "\n" + cookie.getPath().toLowerCase();
        for (org.apache.http.cookie.Cookie cur : cookies) {
            String curString = cur.getDomain().toLowerCase() + "\n" + cur.getName().toLowerCase() + "\n" + cur.getPath().toLowerCase();
            if (!toDelete.equals(curString)) continue;
            this.removeFromCookieStore(cur);
        }
    }

    private void removeFromCookieStore(org.apache.http.cookie.Cookie cookie) {
        BasicClientCookie tmp = new BasicClientCookie(cookie.getName(), "");
        tmp.setDomain(cookie.getDomain());
        tmp.setPath(cookie.getPath());
        tmp.setExpiryDate(new Date(0L));
        cookieStore.addCookie((org.apache.http.cookie.Cookie)tmp);
    }

    @Override
    public void deleteCookieNamed(String name) {
        for (org.apache.http.cookie.Cookie cur : cookieStore.getCookies()) {
            if (!cur.getName().equals(name)) continue;
            this.removeFromCookieStore(cur);
        }
    }

    @Override
    public Cookie getCookieNamed(String name) {
        for (org.apache.http.cookie.Cookie cur : cookieStore.getCookies()) {
            if (!cur.getName().equals(name)) continue;
            return OptionsServer.convert(cur);
        }
        return null;
    }

    @Override
    public Set<Cookie> getCookies() {
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        for (org.apache.http.cookie.Cookie cur : cookieStore.getCookies()) {
            cookies.add(OptionsServer.convert(cur));
        }
        return cookies;
    }

    @Override
    public ImeHandlerServer ime() {
        return this.imeHandler;
    }

    @Override
    public LogsServer logs() {
        return LogsServer.instance();
    }

    @Override
    public TimeoutsServer timeouts() {
        return this.timeouts.get();
    }

    @Override
    public WindowServer window() {
        return this.context.item().window.get();
    }
}

