/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins.test.output;

import com.google.common.collect.ImmutableCollection;
import com.mabl.integration.jenkins.test.output.Failure;
import com.mabl.integration.jenkins.test.output.Properties;
import com.mabl.integration.jenkins.test.output.Property;
import com.mabl.integration.jenkins.test.output.Skipped;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.Collection;

@XStreamAlias(value="testcase")
public class TestCase {
    @XStreamAsAttribute
    @XStreamAlias(value="classname")
    private String plan;
    @XStreamAsAttribute
    @XStreamAlias(value="name")
    private String journey;
    @XStreamAsAttribute
    @XStreamAlias(value="time")
    private long duration;
    @XStreamAsAttribute
    @XStreamAlias(value="xlink:type")
    private String linkType;
    @XStreamAsAttribute
    @XStreamAlias(value="xlink:href")
    private String appHref;
    private Failure failure;
    @XStreamAsAttribute
    private Skipped skipped;
    private Properties properties;

    public TestCase() {
    }

    public TestCase(String plan, String journey, long duration, String appHref) {
        this(plan, journey, duration, appHref, null);
    }

    public TestCase(String plan, String journey, long duration, String appHref, Failure failure) {
        this.plan = plan;
        this.journey = journey;
        this.duration = duration;
        this.linkType = "simple";
        this.appHref = appHref;
        this.failure = failure;
    }

    public void setTestCaseIDs(Collection<String> testCaseIDs) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.addProperty("requirement", String.join((CharSequence)",", testCaseIDs));
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public void setSkipped() {
        this.skipped = new Skipped();
    }

    public String getPlan() {
        return this.plan;
    }

    public String getJourney() {
        return this.journey;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getAppHref() {
        return this.appHref;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public ImmutableCollection<Property> getProperties() {
        return this.properties.getProperties();
    }

    public Skipped getSkipped() {
        return this.skipped;
    }
}

