/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListLevel;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;

public class RtfListItem
extends RtfParagraph {
    private RtfListLevel parentList = null;
    private boolean containsInnerList = false;
    private int level = 0;

    public RtfListItem(RtfDocument rtfDocument, ListItem listItem) {
        super(rtfDocument, (Paragraph)listItem);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.paragraphStyle.getSpacingBefore() > 0) {
            outputStream.write(RtfParagraphStyle.SPACING_BEFORE);
            outputStream.write(this.intToByteArray(this.paragraphStyle.getSpacingBefore()));
        }
        if (this.paragraphStyle.getSpacingAfter() > 0) {
            outputStream.write(RtfParagraphStyle.SPACING_AFTER);
            outputStream.write(this.intToByteArray(this.paragraphStyle.getSpacingAfter()));
        }
        block5: for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfBasicElement instanceof RtfChunk) {
                ((RtfChunk)rtfBasicElement).setSoftLineBreaks(true);
            } else if (rtfBasicElement instanceof RtfList) {
                outputStream.write(RtfParagraph.PARAGRAPH);
                this.containsInnerList = true;
            }
            rtfBasicElement.writeContent(outputStream);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            switch (this.parentList.getLevelFollowValue()) {
                case 2: {
                    continue block5;
                }
                case 0: {
                    this.parentList.writeListBeginning(outputStream);
                    outputStream.write(RtfList.TAB);
                    continue block5;
                }
                case 1: {
                    this.parentList.writeListBeginning(outputStream);
                    outputStream.write(" ".getBytes());
                }
            }
        }
    }

    public boolean writeDefinition(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            RtfList rtfList = (RtfList)rtfBasicElement;
            rtfList.writeDefinition(outputStream);
            return true;
        }
        return false;
    }

    public void inheritListSettings(int n, int n2) {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            ((RtfList)rtfBasicElement).setListNumber(n);
            this.setLevel(n2);
        }
    }

    protected void correctIndentation() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            if (!(rtfBasicElement instanceof RtfList)) continue;
            ((RtfList)rtfBasicElement).correctIndentation();
        }
    }

    public void setParent(RtfListLevel rtfListLevel) {
        this.parentList = rtfListLevel;
    }

    public RtfListLevel getParent() {
        return this.parentList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }
}

