/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.RomanList;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListLevel;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    public static final byte[] LIST_NUMBER = "\\ls".getBytes();
    private static final byte[] LIST = "\\list".getBytes();
    public static final byte[] LIST_ID = "\\listid".getBytes();
    private static final byte[] LIST_TEMPLATE_ID = "\\listtemplateid".getBytes();
    private static final byte[] LIST_SIMPLE = "\\listsimple".getBytes();
    private static final byte[] LIST_HYBRID = "\\listhybrid".getBytes();
    private static final byte[] LIST_RESTARTHDN = "\\listrestarthdn".getBytes();
    private static final byte[] LIST_NAME = "\\listname".getBytes();
    private static final byte[] LIST_STYLEID = "\\liststyleid".getBytes();
    private static final byte[] LIST_STYLENAME = "\\liststylename".getBytes();
    public static final byte[] LIST_LEVEL_NUMBER = "\\ilvl".getBytes();
    public static final byte[] LIST_TEXT = "\\listtext".getBytes();
    public static final byte[] LIST_NUMBER_END = ".".getBytes();
    public static final byte[] TAB = "\\tab".getBytes();
    private ArrayList items;
    private RtfList parentList = null;
    private int listID = -1;
    public static final int LIST_TYPE_NORMAL = 0;
    public static final int LIST_TYPE_SIMPLE = 1;
    public static final int LIST_TYPE_HYBRID = 2;
    private int listType = 2;
    private String name = null;
    private int listNumber = -1;
    private ArrayList listLevels = null;

    public RtfList() {
        super(null);
        this.createDefaultLevels();
    }

    public void setDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
    }

    public RtfList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.createDefaultLevels();
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
    }

    public RtfList(RtfDocument rtfDocument, List list) {
        super(rtfDocument);
        this.createDefaultLevels();
        this.items = new ArrayList();
        RtfListLevel rtfListLevel = (RtfListLevel)this.listLevels.get(0);
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        if (list.getSymbolIndent() > 0.0f && list.getIndentationLeft() > 0.0f) {
            rtfListLevel.setFirstIndent((int)((double)list.getSymbolIndent() * 20.0 * -1.0));
            rtfListLevel.setLeftIndent((int)((double)(list.getIndentationLeft() + list.getSymbolIndent()) * 20.0));
        } else if (list.getSymbolIndent() > 0.0f) {
            rtfListLevel.setFirstIndent((int)((double)list.getSymbolIndent() * 20.0 * -1.0));
            rtfListLevel.setLeftIndent((int)((double)list.getSymbolIndent() * 20.0));
        } else if (list.getIndentationLeft() > 0.0f) {
            rtfListLevel.setFirstIndent(0);
            rtfListLevel.setLeftIndent((int)((double)list.getIndentationLeft() * 20.0));
        } else {
            rtfListLevel.setFirstIndent(0);
            rtfListLevel.setLeftIndent(0);
        }
        rtfListLevel.setRightIndent((int)((double)list.getIndentationRight() * 20.0));
        rtfListLevel.setSymbolIndent((int)((double)(list.getSymbolIndent() + list.getIndentationLeft()) * 20.0));
        rtfListLevel.correctIndentation();
        rtfListLevel.setTentative(false);
        if (list instanceof RomanList) {
            if (list.isLowercase()) {
                rtfListLevel.setListType(5);
            } else {
                rtfListLevel.setListType(4);
            }
        } else if (list.isNumbered()) {
            rtfListLevel.setListType(1);
        } else if (list.isLettered()) {
            if (list.isLowercase()) {
                rtfListLevel.setListType(3);
            } else {
                rtfListLevel.setListType(2);
            }
        } else {
            rtfListLevel.setBulletCharacter(list.getPreSymbol() + list.getSymbol().getContent() + list.getPostSymbol());
            rtfListLevel.setListType(1023);
        }
        for (int i = 0; i < list.getItems().size(); ++i) {
            try {
                Element element = (Element)list.getItems().get(i);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if (element instanceof ListItem) {
                    rtfListLevel.setAlignment(((ListItem)element).getAlignment());
                }
                RtfBasicElement[] rtfBasicElementArray = rtfDocument.getMapper().mapElement(element);
                for (int j = 0; j < rtfBasicElementArray.length; ++j) {
                    RtfBasicElement rtfBasicElement = rtfBasicElementArray[j];
                    if (rtfBasicElement instanceof RtfList) {
                        ((RtfList)rtfBasicElement).setParentList(this);
                    } else if (rtfBasicElement instanceof RtfListItem) {
                        ((RtfListItem)rtfBasicElement).setParent(rtfListLevel);
                    }
                    rtfListLevel.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
                    if (list.getSymbol() != null && list.getSymbol().getFont() != null && !list.getSymbol().getContent().startsWith("-") && list.getSymbol().getContent().length() > 0) {
                        rtfListLevel.setBulletFont(list.getSymbol().getFont());
                        rtfListLevel.setBulletCharacter(list.getSymbol().getContent().substring(0, 1));
                    } else {
                        rtfListLevel.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
                    }
                    this.items.add(rtfBasicElement);
                }
                continue;
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        int n;
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST);
        outputStream.write(LIST_TEMPLATE_ID);
        outputStream.write(this.intToByteArray(this.document.getRandomInt()));
        int n2 = -1;
        switch (this.listType) {
            case 0: {
                n2 = this.listLevels.size();
                break;
            }
            case 1: {
                outputStream.write(LIST_SIMPLE);
                outputStream.write(this.intToByteArray(1));
                n2 = 1;
                break;
            }
            case 2: {
                outputStream.write(LIST_HYBRID);
                n2 = this.listLevels.size();
                break;
            }
        }
        this.document.outputDebugLinebreak(outputStream);
        for (n = 0; n < n2; ++n) {
            ((RtfListLevel)this.listLevels.get(n)).writeDefinition(outputStream);
            this.document.outputDebugLinebreak(outputStream);
        }
        outputStream.write(LIST_ID);
        outputStream.write(this.intToByteArray(this.listID));
        outputStream.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
        if (this.items != null) {
            for (n = 0; n < this.items.size(); ++n) {
                RtfElement rtfElement;
                RtfElement rtfElement2 = (RtfElement)this.items.get(n);
                if (rtfElement2 instanceof RtfList) {
                    rtfElement = (RtfList)rtfElement2;
                    ((RtfList)rtfElement).writeDefinition(outputStream);
                    break;
                }
                if (rtfElement2 instanceof RtfListItem && ((RtfListItem)(rtfElement = (RtfListItem)rtfElement2)).writeDefinition(outputStream)) break;
            }
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (!this.inTable) {
            outputStream.write(OPEN_GROUP);
        }
        int n = 0;
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                RtfElement rtfElement = (RtfElement)this.items.get(i);
                if (rtfElement instanceof RtfListItem) {
                    ++n;
                    RtfListItem rtfListItem = (RtfListItem)rtfElement;
                    RtfListLevel rtfListLevel = rtfListItem.getParent();
                    if (rtfListLevel.getListLevel() == 0) {
                        this.correctIndentation();
                    }
                    if (i == 0) {
                        rtfListLevel.writeListBeginning(outputStream);
                        this.writeListNumbers(outputStream);
                    }
                    this.writeListTextBlock(outputStream, n, rtfListLevel);
                    rtfListItem.writeContent(outputStream);
                    if (i < this.items.size() - 1 || !this.inTable || rtfListLevel.getListType() > 0) {
                        outputStream.write(RtfParagraph.PARAGRAPH);
                    }
                    this.document.outputDebugLinebreak(outputStream);
                    continue;
                }
                if (!(rtfElement instanceof RtfList)) continue;
                ((RtfList)rtfElement).writeContent(outputStream);
                this.writeListNumbers(outputStream);
                this.document.outputDebugLinebreak(outputStream);
            }
        }
        if (!this.inTable) {
            outputStream.write(CLOSE_GROUP);
            outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
    }

    protected void writeListTextBlock(OutputStream outputStream, int n, RtfListLevel rtfListLevel) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(LIST_TEXT);
        outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        if (this.inTable) {
            outputStream.write(RtfParagraph.IN_TABLE);
        }
        outputStream.write(RtfFontList.FONT_NUMBER);
        if (rtfListLevel.getListType() != 1023) {
            outputStream.write(this.intToByteArray(rtfListLevel.getFontNumber().getFontNumber()));
        } else {
            outputStream.write(this.intToByteArray(rtfListLevel.getFontBullet().getFontNumber()));
        }
        rtfListLevel.writeIndentation(outputStream);
        outputStream.write(DELIMITER);
        if (rtfListLevel.getListType() != 1023) {
            switch (rtfListLevel.getListType()) {
                case 1: {
                    outputStream.write(this.intToByteArray(n));
                    break;
                }
                case 2: {
                    outputStream.write(RomanAlphabetFactory.getUpperCaseString((int)n).getBytes());
                    break;
                }
                case 3: {
                    outputStream.write(RomanAlphabetFactory.getLowerCaseString((int)n).getBytes());
                    break;
                }
                case 4: {
                    outputStream.write(RomanNumberFactory.getUpperCaseString((int)n).getBytes());
                    break;
                }
                case 5: {
                    outputStream.write(RomanNumberFactory.getLowerCaseString((int)n).getBytes());
                }
            }
            outputStream.write(LIST_NUMBER_END);
        } else {
            this.document.filterSpecialChar(outputStream, rtfListLevel.getBulletCharacter(), true, false);
        }
        outputStream.write(TAB);
        outputStream.write(CLOSE_GROUP);
    }

    protected void writeListNumbers(OutputStream outputStream) throws IOException {
        outputStream.write(LIST_NUMBER);
        outputStream.write(this.intToByteArray(this.listNumber));
    }

    protected void createDefaultLevels() {
        this.listLevels = new ArrayList();
        for (int i = 0; i <= 8; ++i) {
            RtfListLevel rtfListLevel = new RtfListLevel(this.document);
            rtfListLevel.setListType(1);
            rtfListLevel.setFirstIndent(0);
            rtfListLevel.setLeftIndent(0);
            rtfListLevel.setLevelTextNumber(i);
            rtfListLevel.setTentative(true);
            rtfListLevel.correctIndentation();
            this.listLevels.add(rtfListLevel);
        }
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int n) {
        this.listNumber = n;
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(bl);
        }
    }

    protected void correctIndentation() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) instanceof RtfList) {
                ((RtfList)this.items.get(i)).correctIndentation();
                continue;
            }
            if (!(this.items.get(i) instanceof RtfListItem)) continue;
            ((RtfListItem)this.items.get(i)).correctIndentation();
        }
    }

    public void setID(int n) {
        this.listID = n;
    }

    public int getID() {
        return this.listID;
    }

    public int getListType() {
        return this.listType;
    }

    public void setListType(int n) throws InvalidParameterException {
        if (n != 0 && n != 1 && n != 2) {
            throw new InvalidParameterException("Invalid listType value.");
        }
        this.listType = n;
    }

    public RtfList getParentList() {
        return this.parentList;
    }

    public void setParentList(RtfList rtfList) {
        this.parentList = rtfList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public RtfListLevel getListLevel(int n) {
        if (this.listLevels != null) {
            return (RtfListLevel)this.listLevels.get(n);
        }
        return null;
    }
}

