/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.es.service.impl;

import com.google.common.collect.Lists;
import com.lmaye.app.common.context.IResultCode;
import com.lmaye.app.common.context.PageResult;
import com.lmaye.app.common.context.ResultCode;
import com.lmaye.app.common.exception.ServiceException;
import com.lmaye.app.common.query.ListQuery;
import com.lmaye.app.common.query.PageQuery;
import com.lmaye.starter.data.es.repository.IElasticSearchRepository;
import com.lmaye.starter.data.es.service.IElasticSearchService;
import com.lmaye.starter.data.es.utils.ElasticSearchUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ElasticSearchServiceImpl<R extends IElasticSearchRepository<T, ID>, T, ID extends Serializable>
implements IElasticSearchService<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchServiceImpl.class);
    private final R repository;
    @Resource
    private ElasticsearchOperations elasticsearchOperations;
    @Resource
    private RestHighLevelClient restHighLevelClient;

    public ElasticSearchServiceImpl(R repository) {
        this.repository = repository;
    }

    @Override
    public <S extends T> S insertOrUpdate(S entity) {
        try {
            return (S)this.repository.save(entity);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        try {
            return this.repository.saveAll(entities);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public void deleteById(ID id) {
        try {
            this.repository.deleteById(id);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public Optional<T> findById(ID id) {
        try {
            return this.repository.findById(id);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public List<T> findAll(com.lmaye.app.common.query.Query query, Class<T> clazz) {
        try {
            if (Objects.isNull(query)) {
                return Lists.newArrayList((Iterable)this.repository.findAll());
            }
            NativeSearchQuery searchQuery = new NativeSearchQuery(ElasticSearchUtil.convert(query));
            searchQuery.setMaxResults(Integer.valueOf(1000));
            Document doc = clazz.getAnnotation(Document.class);
            SearchHits searchHits = !Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName()) ? this.elasticsearchOperations.search((Query)searchQuery, clazz, IndexCoordinates.of((String[])new String[]{doc.indexName()})) : this.elasticsearchOperations.search((Query)searchQuery, clazz);
            return searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public List<T> findAll(ListQuery query, Class<T> clazz) {
        try {
            if (Objects.isNull(query) || Objects.isNull(query.getQuery())) {
                return Lists.newArrayList((Iterable)this.repository.findAll());
            }
            NativeSearchQuery searchQuery = new NativeSearchQuery(ElasticSearchUtil.convert(query.getQuery()));
            if (!Objects.isNull(query.getSort()) && !CollectionUtils.isEmpty((Collection)query.getSort().getOrder())) {
                query.getSort().getOrder().forEach(it -> searchQuery.addSort(Sort.by((Sort.Order[])new Sort.Order[]{Objects.equals(1, it.getAsc()) ? Sort.Order.asc((String)it.getName()) : Sort.Order.desc((String)it.getName())})));
            }
            searchQuery.setMaxResults(Integer.valueOf(1000));
            Document doc = clazz.getAnnotation(Document.class);
            SearchHits searchHits = !Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName()) ? this.elasticsearchOperations.search((Query)searchQuery, clazz, IndexCoordinates.of((String[])new String[]{doc.indexName()})) : this.elasticsearchOperations.search((Query)searchQuery, clazz);
            return searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public List<T> findScrollAll(ListQuery query, Class<T> clazz) {
        try {
            if (Objects.isNull(query) || Objects.isNull(query.getQuery())) {
                return Lists.newArrayList((Iterable)this.repository.findAll());
            }
            return ElasticSearchUtil.searchScrollAll(this.restHighLevelClient, query, 60L, clazz);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public PageResult<T> findPage(PageQuery query, Class<T> clazz) {
        try {
            NativeSearchQuery searchQuery = new NativeSearchQuery(ElasticSearchUtil.convert(query.getQuery()));
            if (!Objects.isNull(query.getSort()) && !CollectionUtils.isEmpty((Collection)query.getSort().getOrder())) {
                query.getSort().getOrder().forEach(it -> searchQuery.addSort(Sort.by((Sort.Order[])new Sort.Order[]{Objects.equals(1, it.getAsc()) ? Sort.Order.asc((String)it.getName()) : Sort.Order.desc((String)it.getName())})));
            }
            int pageIndex = query.getPageIndex() - 1;
            Integer pageSize = query.getPageSize();
            searchQuery.setPageable((Pageable)PageRequest.of((int)pageIndex, (int)pageSize));
            Document doc = clazz.getAnnotation(Document.class);
            log.info(">>> searchQuery <<< {}", (Object)searchQuery.getQuery());
            SearchHits searchHits = !Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName()) ? this.elasticsearchOperations.search((Query)searchQuery, clazz, IndexCoordinates.of((String[])new String[]{doc.indexName()})) : this.elasticsearchOperations.search((Query)searchQuery, clazz);
            long total = searchHits.getTotalHits();
            long pages = (long)Math.ceil((float)total / (float)pageSize.intValue());
            return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(Objects.equals(0L, pages) ? 1L : pages)).setTotal(Long.valueOf(total)).setRecords(searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public PageResult<T> findScrollPage(PageQuery query, Class<T> clazz) {
        try {
            return ElasticSearchUtil.searchScrollPage(this.restHighLevelClient, query, 60000L, clazz);
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }

    @Override
    public long count(com.lmaye.app.common.query.Query query, Class<T> clazz) {
        try {
            Document doc = clazz.getAnnotation(Document.class);
            if (Objects.isNull(doc) || StringUtils.isBlank((CharSequence)doc.indexName())) {
                return 0L;
            }
            QueryBuilder queryBuilder = ElasticSearchUtil.convert(query);
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(queryBuilder).build();
            return this.elasticsearchOperations.count((Query)searchQuery, IndexCoordinates.of((String[])new String[]{doc.indexName()}));
        }
        catch (Exception e) {
            throw new ServiceException((IResultCode)ResultCode.OPERATION_FAILED, (Throwable)e);
        }
    }
}

