/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.FatalExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.TimeoutHandler;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BatchEventProcessor<T>
implements EventProcessor {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ExceptionHandler exceptionHandler = new FatalExceptionHandler();
    private final RingBuffer<T> ringBuffer;
    private final SequenceBarrier sequenceBarrier;
    private final EventHandler<T> eventHandler;
    private final Sequence sequence = new Sequence(-1L);
    private final TimeoutHandler timeoutHandler;

    public BatchEventProcessor(RingBuffer<T> ringBuffer, SequenceBarrier sequenceBarrier, EventHandler<T> eventHandler) {
        this.ringBuffer = ringBuffer;
        this.sequenceBarrier = sequenceBarrier;
        this.eventHandler = eventHandler;
        if (eventHandler instanceof SequenceReportingEventHandler) {
            ((SequenceReportingEventHandler)eventHandler).setSequenceCallback(this.sequence);
        }
        this.timeoutHandler = eventHandler instanceof TimeoutHandler ? (TimeoutHandler)((Object)eventHandler) : null;
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void halt() {
        this.running.set(false);
        this.sequenceBarrier.alert();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (null == exceptionHandler) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Thread is already running");
        }
        this.sequenceBarrier.clearAlert();
        this.notifyStart();
        Object event = null;
        long nextSequence = this.sequence.get() + 1L;
        while (true) {
            try {
                while (true) {
                    long availableSequence;
                    if ((availableSequence = this.sequenceBarrier.waitFor(nextSequence)) < nextSequence && this.timeoutHandler != null) {
                        this.notifyTimeout(availableSequence);
                        continue;
                    }
                    while (nextSequence <= availableSequence) {
                        event = this.ringBuffer.getPublished(nextSequence);
                        this.eventHandler.onEvent(event, nextSequence, nextSequence == availableSequence);
                        ++nextSequence;
                    }
                    this.sequence.set(availableSequence);
                }
            }
            catch (AlertException ex) {
                if (this.running.get()) continue;
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleEventException(ex, nextSequence, event);
                this.sequence.set(nextSequence);
                ++nextSequence;
                continue;
            }
            break;
        }
        this.notifyShutdown();
        this.running.set(false);
    }

    private void notifyTimeout(long availableSequence) throws Exception {
        try {
            this.timeoutHandler.onTimeout(availableSequence);
        }
        catch (Throwable e) {
            this.exceptionHandler.handleEventException(e, availableSequence, null);
        }
    }

    private void notifyStart() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.eventHandler)).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.eventHandler)).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

