/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.dsl.EventProcessorInfo;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

class EventProcessorRepository<T>
implements Iterable<EventProcessorInfo<T>> {
    private final Map<EventHandler<?>, EventProcessorInfo<T>> eventProcessorInfoByHandler = new IdentityHashMap();
    private final Map<EventProcessor, EventProcessorInfo<T>> eventProcessorInfoByEventProcessor = new IdentityHashMap<EventProcessor, EventProcessorInfo<T>>();

    EventProcessorRepository() {
    }

    public void add(EventProcessor eventprocessor, EventHandler<T> handler, SequenceBarrier barrier) {
        EventProcessorInfo<T> eventProcessorInfo = new EventProcessorInfo<T>(eventprocessor, handler, barrier);
        this.eventProcessorInfoByHandler.put(handler, eventProcessorInfo);
        this.eventProcessorInfoByEventProcessor.put(eventprocessor, eventProcessorInfo);
    }

    public void add(EventProcessor processor) {
        EventProcessorInfo eventProcessorInfo = new EventProcessorInfo(processor, null, null);
        this.eventProcessorInfoByEventProcessor.put(processor, eventProcessorInfo);
    }

    public EventProcessor[] getLastEventProcessorsInChain() {
        ArrayList<EventProcessor> lastEventProcessors = new ArrayList<EventProcessor>();
        for (EventProcessorInfo<T> eventProcessorInfo : this.eventProcessorInfoByEventProcessor.values()) {
            if (!eventProcessorInfo.isEndOfChain()) continue;
            lastEventProcessors.add(eventProcessorInfo.getEventProcessor());
        }
        return lastEventProcessors.toArray(new EventProcessor[lastEventProcessors.size()]);
    }

    public EventProcessor getEventProcessorFor(EventHandler<T> handler) {
        EventProcessorInfo<T> eventprocessorInfo = this.getEventProcessorInfo(handler);
        if (eventprocessorInfo == null) {
            throw new IllegalArgumentException("The event handler " + handler + " is not processing events.");
        }
        return eventprocessorInfo.getEventProcessor();
    }

    public void unMarkEventProcessorsAsEndOfChain(EventProcessor ... barrierEventProcessors) {
        for (EventProcessor barrierEventProcessor : barrierEventProcessors) {
            this.getEventProcessorInfo(barrierEventProcessor).markAsUsedInBarrier();
        }
    }

    @Override
    public Iterator<EventProcessorInfo<T>> iterator() {
        return this.eventProcessorInfoByEventProcessor.values().iterator();
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        EventProcessorInfo<T> eventProcessorInfo = this.getEventProcessorInfo(handler);
        return eventProcessorInfo != null ? eventProcessorInfo.getBarrier() : null;
    }

    private EventProcessorInfo<T> getEventProcessorInfo(EventHandler<T> handler) {
        return this.eventProcessorInfoByHandler.get(handler);
    }

    private EventProcessorInfo<T> getEventProcessorInfo(EventProcessor barrierEventProcessor) {
        return this.eventProcessorInfoByEventProcessor.get(barrierEventProcessor);
    }
}

