/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.EventProcessorRepository;
import com.lmax.disruptor.util.Util;

public class EventHandlerGroup<T> {
    private final Disruptor<T> disruptor;
    private final EventProcessorRepository<T> eventProcessorRepository;
    private final EventProcessor[] eventProcessors;

    EventHandlerGroup(Disruptor<T> disruptor, EventProcessorRepository<T> eventProcessorRepository, EventProcessor[] eventProcessors) {
        this.disruptor = disruptor;
        this.eventProcessorRepository = eventProcessorRepository;
        this.eventProcessors = eventProcessors;
    }

    public EventHandlerGroup<T> and(EventHandler<T> ... handlers) {
        EventProcessor[] combinedProcessors = new EventProcessor[this.eventProcessors.length + handlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            combinedProcessors[i] = this.eventProcessorRepository.getEventProcessorFor(handlers[i]);
        }
        System.arraycopy(this.eventProcessors, 0, combinedProcessors, handlers.length, this.eventProcessors.length);
        return new EventHandlerGroup<T>(this.disruptor, this.eventProcessorRepository, combinedProcessors);
    }

    public EventHandlerGroup<T> and(EventProcessor ... processors) {
        EventProcessor[] combinedProcessors = new EventProcessor[this.eventProcessors.length + processors.length];
        for (EventProcessor processor : processors) {
            this.eventProcessorRepository.add(processor);
        }
        System.arraycopy(processors, 0, combinedProcessors, 0, processors.length);
        System.arraycopy(this.eventProcessors, 0, combinedProcessors, processors.length, this.eventProcessors.length);
        return new EventHandlerGroup<T>(this.disruptor, this.eventProcessorRepository, combinedProcessors);
    }

    public EventHandlerGroup<T> then(EventHandler<T> ... handlers) {
        return this.handleEventsWith(handlers);
    }

    public EventHandlerGroup<T> handleEventsWith(EventHandler<T> ... handlers) {
        return this.disruptor.createEventProcessors(this.eventProcessors, handlers);
    }

    public SequenceBarrier asSequenceBarrier() {
        return this.disruptor.getRingBuffer().newBarrier(Util.getSequencesFor(this.eventProcessors));
    }
}

