/*
 * Decompiled with CFR 0.152.
 */
package com.livquik.qwcore;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory internalSSLSocketFactory;

    public TLSSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, null, null);
        this.internalSSLSocketFactory = sSLContext.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.internalSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.internalSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket());
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(socket, string, n, bl));
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(string, n));
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(string, n, inetAddress, n2));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(inetAddress, n));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(inetAddress, n, inetAddress2, n2));
    }

    private Socket enableTLSOnSocket(Socket socket) {
        if (socket != null && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1.1", "TLSv1.2"});
        }
        return socket;
    }
}

