/*
 * Decompiled with CFR 0.152.
 */
package com.livquik.qwcore.helper;

import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.livquik.qwcore.TLSSocketFactory;
import com.livquik.qwcore.helper.ConfigurationHelper;
import com.livquik.qwcore.helper.ConnectivityHelper;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.AjaxEndEvent;
import com.livquik.qwcore.pojo.common.AjaxStartEvent;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.common.Configuration;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import de.greenrobot.event.EventBus;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

public class AjaxHelper {
    private static final String TAG = AjaxHelper.class.getName();

    public static <Data> GenericResponse<Data> ajax(String string, String string2, BaseRequest baseRequest, Type type, String string3) throws QWException {
        Object object;
        EventBus.getDefault().post((Object)new AjaxStartEvent());
        if (baseRequest != null) {
            baseRequest.setPlatform("android");
            baseRequest.setSdkversion("2.1.3");
        }
        Gson gson = new Gson();
        String string4 = AjaxHelper.getAjaxUrl(string);
        if (string3 != null) {
            string4 = string4 + "/" + string3;
        }
        Log.d((String)TAG, (String)("Request URL is ->" + string4));
        String string5 = null;
        if (Configuration.getContext() != null && !ConnectivityHelper.checkConnectivity(Configuration.getContext())) {
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Your device seems to have problem connecting to the network. Please check your internet connection.");
        }
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        int n = 0;
        try {
            String string6;
            object = new OkHttpClient();
            if (Build.VERSION.SDK_INT <= 19) {
                object.setSslSocketFactory((SSLSocketFactory)new TLSSocketFactory());
            }
            object.setConnectTimeout(180000L, TimeUnit.MILLISECONDS);
            object.setReadTimeout(180000L, TimeUnit.MILLISECONDS);
            object.setWriteTimeout(180000L, TimeUnit.MILLISECONDS);
            if (string2.equals("post")) {
                string6 = gson.toJson((Object)baseRequest);
                Log.d((String)TAG, (String)("Request is ->" + string6));
                RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)string6);
                Request request = new Request.Builder().url(string4).post(requestBody).build();
                Response response = object.newCall(request).execute();
                n = response.code();
                Log.d((String)TAG, (String)("Response status is " + n));
                string5 = response.body().string();
            } else if (string2.equals("get")) {
                string6 = new Request.Builder().url(string4).get().build();
                Response response = object.newCall((Request)string6).execute();
                string5 = response.body().string();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Log.e((String)TAG, (String)("UnknownHostException " + unknownHostException));
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Your device seems to have problem connecting to the network. Please check your internet connection.");
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"IOException: The request could not be executed due to cancellation, a connectivity problem or timeout");
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Your device seems to have problem connecting to the network. Please check your internet connection.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)(illegalArgumentException + ""));
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Something went wrong");
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"OOPS!! Unable to call server");
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("OOPS!! Unable to call server");
        }
        object = null;
        try {
            object = gson.fromJson(string5, type);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            Log.e((String)TAG, (String)("Unable to create response object HTTP Status code : " + n + "\n Exception Details" + (Object)((Object)jsonSyntaxException)));
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Something went wrong");
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error while creating response object " + exception));
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Something went wrong");
        }
        Log.d((String)TAG, (String)("Response from server is -> " + string5));
        if (object == null) {
            Log.e((String)TAG, (String)"NULL RESPONSE");
            EventBus.getDefault().post((Object)new AjaxEndEvent());
            throw new QWException("Network Failure/Timeout or null returned by the server");
        }
        EventBus.getDefault().post((Object)new AjaxEndEvent());
        return (GenericResponse)object;
    }

    public static String getAjaxUrl(String string) {
        return AjaxHelper.getBasicUrl() + "/" + "api/user/wallet" + "/" + string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getBasicUrl() {
        Configuration configuration = ConfigurationHelper.getConfiguration();
        String string = configuration.getCurrentConfig().equals("dev") ? "http" : "https";
        String string2 = "";
        String string3 = "";
        string2 = configuration.getCurrentConfig().equalsIgnoreCase("dev") ? "192.168.1.100" : (configuration.getCurrentConfig().equalsIgnoreCase("uat") ? "uat.quikwallet.com" : (configuration.getCurrentConfig().equalsIgnoreCase("test") ? "test.quikwallet.com" : (configuration.getCurrentConfig().equalsIgnoreCase("staging") ? "staging.quikpay.in" : "server.livquik.com")));
        if (configuration.getPORT() != "") {
            if (configuration.getPORT() != null) {
                string3 = ":" + configuration.getPORT();
                return string + "://" + string2 + string3;
            }
        }
        if (configuration.getCurrentConfig().equalsIgnoreCase("dev")) {
            string3 = ":3014";
            return string + "://" + string2 + string3;
        }
        string3 = "";
        return string + "://" + string2 + string3;
    }
}

