package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.request.login.LoginRequest;
import com.livquik.qwcore.pojo.response.login.LoginResponse;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.login.ChangePasswordRequest;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.login.ChangePasswordResponse;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class LoginHelper {
    /**
     * @param changePasswordRequest Request bean.
     * @return ChangePasswordResponse bean containing response.
     * @throws QWException in case of null response/timeout.
     */
    public ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws QWException {
        RequestValidator.validate(changePasswordRequest);
        Type finalType = new TypeToken<GenericResponse<ChangePasswordResponse>>() {
        }.getType();
        GenericResponse<ChangePasswordResponse> changePasswordResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CHANGE_PASSWORD, Constants.Ajax.REQUEST_POST, changePasswordRequest, finalType, null);
        return (ChangePasswordResponse) new ResponseProcessing<ChangePasswordResponse>(ChangePasswordResponse.class).processResponse(changePasswordResponse);
    }

    public LoginResponse login(LoginRequest loginRequest) throws QWException {
        Type finalType = new TypeToken<GenericResponse<LoginResponse>>() {
        }.getType();
        GenericResponse<LoginResponse> loginResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_LOGIN, Constants.Ajax.REQUEST_POST, loginRequest, finalType, null);
        return (LoginResponse) new ResponseProcessing<LoginResponse>(LoginResponse.class).processResponse(loginResponse);
    }
}
