package com.livquik.qwcore.helper;

import android.content.Context;

import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.common.Configuration;

import java.util.regex.PatternSyntaxException;

/**
 * Created by turing on 3/8/15.
 */
public class ConfigurationHelper {
    private static Configuration serverConfig = new Configuration();


    public ConfigurationHelper() {
        serverConfig.setCurrentConfig(Constants.Configs.LIVE);
        serverConfig.setPORT("");
    }

    public ConfigurationHelper(String current_config, Context context) {
        serverConfig.setContext(context);
        try {
            if (current_config.contains(":")) {
                String[] tokens = current_config.split(":");
                serverConfig.setCurrentConfig(tokens[0]);
                serverConfig.setPORT(tokens[1]);
            } else {
                serverConfig.setCurrentConfig(current_config);
            }
        } catch (PatternSyntaxException e) {
            System.out.println("Invalid Configuration parameter. Loading default");
            serverConfig.setCurrentConfig(Constants.Configs.LIVE);
        }
    }

    public static void init() {
        serverConfig.setCurrentConfig(Constants.Configs.LIVE);
        serverConfig.setPORT("");
    }

    public static void init(Context context) {
        serverConfig.setContext(context);
        init();
    }

    public static void init(String current_config) {
        try {
            if (current_config.contains(":")) {
                String[] tokens = current_config.split(":");
                serverConfig.setCurrentConfig(tokens[0]);
                serverConfig.setPORT(tokens[1]);
            } else {
                serverConfig.setCurrentConfig(current_config);
                serverConfig.setPORT("");
            }
        } catch (PatternSyntaxException e) {
            System.out.println("Invalid Configuration parameter. Loading default");
            serverConfig.setCurrentConfig(Constants.Configs.LIVE);
            serverConfig.setPORT("");
        }
    }

    public static void init(String current_config, Context context) {
        init(current_config);
        serverConfig.setContext(context);
    }

    public static Configuration getServerConfig() {
        return serverConfig;
    }

    public static Configuration getConfiguration() {
        return serverConfig;
    }
}
