package com.livquik.qwcore.helper;

import android.os.Build;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.livquik.qwcore.BuildConfig;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.TLSSocketFactory;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.AjaxEndEvent;
import com.livquik.qwcore.pojo.common.AjaxStartEvent;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.common.Configuration;
import com.livquik.qwcore.pojo.response.common.GenericResponse;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

import de.greenrobot.event.EventBus;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;

/**
 * Created by turing on 2/8/15.
 */
public class AjaxHelper {
    private static final String TAG = AjaxHelper.class.getName();

    /**
     * @param route
     * @param type
     * @param bean
     * @param finalType
     * @param routeOverride
     * @param <Data>
     * @return genericResponse<Data>
     * @throws QWException
     */
    public static <Data> GenericResponse<Data> ajax(String route, String type, BaseRequest bean, Type finalType, String routeOverride) throws QWException {
        EventBus.getDefault().post(new AjaxStartEvent());

        if (bean != null) {
            bean.setPlatform("android");
            bean.setSdkversion(BuildConfig.VERSION_NAME);
        }
        Gson gson = new Gson();
        String url = getAjaxUrl(route);

        if (routeOverride != null)
            url = url + "/" + routeOverride;
        Log.d(TAG, "Request URL is ->" + url);

        String response = null;
        if (Configuration.getContext() != null) {
            if (!ConnectivityHelper.checkConnectivity(Configuration.getContext())) {
                EventBus.getDefault().post(new AjaxEndEvent());
                throw new QWException(Constants.ERROR.NETWORK_UNREACHABLE_MSG);
            }
        }
        MediaType json = MediaType.parse("application/json; charset=utf-8");
        int serverResponseStatus = 000;
        try {
           /* OkHttpClient client = new OkHttpClient.Builder()
                    .connectTimeout(180000, TimeUnit.MILLISECONDS)
                    .writeTimeout(180000, TimeUnit.MILLISECONDS)
                    .readTimeout(180000, TimeUnit.MILLISECONDS)
                    .build();*/
            OkHttpClient client = new OkHttpClient();
            if (android.os.Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT) {
                // only for gingerbread and newer versions
                client.setSslSocketFactory(new TLSSocketFactory());
            }
            client.setConnectTimeout(180000, TimeUnit.MILLISECONDS);
            client.setReadTimeout(180000, TimeUnit.MILLISECONDS);
            client.setWriteTimeout(180000, TimeUnit.MILLISECONDS);
            if (type.equals(Constants.Ajax.REQUEST_POST)) {
                String toSend = gson.toJson(bean);
                Log.d(TAG, "Request is ->" + toSend);
                RequestBody body = RequestBody.create(json, toSend);
                Request request = new Request.Builder().url(url).post(body).build();
                Response responsehttp = client.newCall(request).execute();
                serverResponseStatus = responsehttp.code();
                Log.d(TAG, "Response status is " + serverResponseStatus);

                response = responsehttp.body().string();
            } else if (type.equals(Constants.Ajax.REQUEST_GET)) {
                Request request = new Request.Builder().url(url).get().build();
                Response responsehttp = client.newCall(request).execute();
                response = responsehttp.body().string();
            }
        } catch (UnknownHostException e) {
            Log.e(TAG, "UnknownHostException " + e);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.NETWORK_UNREACHABLE_MSG);
        } catch (IOException e) {
            Log.e(TAG, Constants.ERROR.IOEXCEPTION_IN_AJAX_CALL);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.NETWORK_UNREACHABLE_MSG);
        } catch (IllegalArgumentException e) {
            Log.e(TAG, e + "");
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.SOMETHING_WENT_WRONG);
        } catch (Exception e) {
            Log.e(TAG, Constants.ERROR.UNABLE_TO_CALL_SERVER);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.UNABLE_TO_CALL_SERVER);
        }

        Object result = null;
        try {
            result = gson.fromJson(response, finalType);
        } catch (JsonSyntaxException jsonException) {
            Log.e(TAG, Constants.Ajax.RESPONSE_JSON_EXCEPTION + " HTTP Status code : " + serverResponseStatus + "\n Exception Details" + jsonException);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.SOMETHING_WENT_WRONG);
        } catch (Exception e) {
            Log.e(TAG, Constants.ERROR.ERROR_WHILE_CREATING_RESPONSE_OBJECT + e);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.ERROR.SOMETHING_WENT_WRONG);
        }

        Log.d(TAG, "Response from server is -> " + response);
        if (result == null) {
            Log.e(TAG, Constants.ERROR.NULL_RESPONSE);
            EventBus.getDefault().post(new AjaxEndEvent());
            throw new QWException(Constants.Ajax.RESPONSE_NETWORK_TIMEOUT);
        } else {
            EventBus.getDefault().post(new AjaxEndEvent());
            return (GenericResponse<Data>) result;
        }

    }

    /**
     * @param route
     * @return server url
     */
    //TODO Migration to api/user for partners .. currently not needed .. api/public and api/user both works
    public static String getAjaxUrl(String route) {
        return getBasicUrl() + "/" + Constants.Ajax.ENDPOINT_PREFIX + "/" + route;
    }

    public static String getBasicUrl() {
        String protocol;
        Configuration config = ConfigurationHelper.getConfiguration();
        if (config.getCurrentConfig().equals(Constants.Configs.DEV)) {
            protocol = Constants.Configs.HTTP;
        } else {
            protocol = Constants.Configs.HTTPS;
        }

        String hostname = "";
        String port = "";
        if (config.getCurrentConfig().equalsIgnoreCase(Constants.Configs.DEV)) {
            hostname = Constants.Ajax.SERVER_URL_DEV;
        } else if (config.getCurrentConfig().equalsIgnoreCase(Constants.Configs.UAT)) {
            hostname = Constants.Ajax.SERVER_URL_UAT;
        } else if (config.getCurrentConfig().equalsIgnoreCase(Constants.Configs.TEST)) {
            hostname = Constants.Ajax.SERVER_URL_TEST;
        } else if (config.getCurrentConfig().equalsIgnoreCase(Constants.Configs.STAGING)) {
            hostname = Constants.Ajax.SERVER_URL_STAGING;
        } else {
            hostname = Constants.Ajax.SERVER_URL_LIVE;
        }

        if (config.getPORT() == "" || config.getPORT() == null) {
            if (config.getCurrentConfig().equalsIgnoreCase(Constants.Configs.DEV))
                port = ":" + Constants.Ajax.SERVER_PORT_DEV;
            else {
                port = "";
            }
        } else {
            port = ":" + config.getPORT();
        }
        return protocol + "://" + hostname + port;
    }
}
